/* gpsk31  - PSK31 for Linux with a GTK+ Interface
 * Copyright (C) 2000 Luc Langehegermann, LX2GT
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *
 * Version: 0.2.4 - May 2000
 *
 */

/*
 * Callbacks from the main widget
 */

int ctrl_key_down = 0;		/* is ctrl-key pressed? */

#include <gtk/gtk.h>
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>
#include <stdio.h>
#include <sys/ioctl.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>
#include <termios.h>
#include "main_screen.h"
#include "misc.h"
#include "menu.h"
#include "globals.h"
#include "text.h"

#include "server.h"

void
macro_processor (GtkWidget *w, gpointer *data)		// This functions take the macros, and sends the strings
{				// To the psk31_transmitter class
  int x = GPOINTER_TO_INT (data);
  int i = 0;
  int luc = 255;
  int mc = 0;
  char text[1024];
  text[0] = '\0';

  if (ctrl_key_down == 1) x = x + 8;
  while (luc != '\0')
    {
      luc = ini_settings.text[x][i];
      if (luc == '~')
	{
	  ++i;
	  mc = ini_settings.text[x][i];
	  if (mc == '~')
	    {
	      commPutData ("~", 1);
	      strcat (text, "~");
	      ++i;
	    }
	  if (mc == 't')	// Go to transmit
	    {
		  /* Set TX Freq if net is active */
		  if (GTK_TOGGLE_BUTTON (main_screen.net)->active)
		    {
		      commControl (COMM_TXCH, COMM_FREQ, (int)
				   (100 * gtk_spin_button_get_value_as_float
				    (GTK_SPIN_BUTTON (main_screen.rx_freq))));

		      gtk_spin_button_set_value (GTK_SPIN_BUTTON
						 (main_screen.tx_freq),
						 gtk_spin_button_get_value_as_float
						 (GTK_SPIN_BUTTON
						  (main_screen.rx_freq)));
		    }
		      commControl (COMM_TXCH, COMM_MODE, MO_NORMAL);
		      commControl (COMM_TXCH, COMM_PTT, PTTON|PTTFORCE);
	      ++i;
	    }
	  if (mc == 'r')	// Go to receive after Fixtext
	    {
		  if (GTK_TOGGLE_BUTTON (main_screen.cwid)->active) {
		    commControl (COMM_TXCH, COMM_MODE, MO_CWSEND);
		    commPutData ((char *) &ini_settings.cw_string, 0);
		    }
		  commControl (COMM_TXCH, COMM_PTT, PTTOFF);
		  commControl (COMM_TXCH, COMM_MODE, MO_NORMAL);
	      ++i;
	    }
	  if (mc == 'c')	// Send Callsign
	    {
	      commPutData ((char *) &qsodata.call, 0);
	      strcat (text, qsodata.call);
	      ++i;
	    }
	  if (mc == 'n')
	    {
	      commPutData ((char *) &qsodata.name, 0);
	      strcat (text, qsodata.name);
	      ++i;
	    }
	  if (mc == 'q')
	    {
	      commPutData ((char *) &qsodata.qth, 0);
	      strcat (text, qsodata.qth);
	      ++i;
	    }
	  if (mc == 's')
	    {
	      commPutData ((char *) &qsodata.rst_s, 0);
              strcat (text,qsodata.rst_s);
	      ++i;
	    }
	  if (mc == 'm') 	/* one if the My-strings */
	    {
              ++i;
	      mc = ini_settings.text[x][i];
              if (mc == 'c')
              {
                 commPutData ((char *) &ini_settings.call, 0);
		 strcat (text, ini_settings.call);
              }
              if (mc == 'n')
              {
                 commPutData ((char *) &ini_settings.name, 0);
		 strcat (text, ini_settings.name);
              }
              if (mc == 'q')
		 {
                 commPutData ((char *) &ini_settings.qth, 0);
                 strcat (text, ini_settings.qth);
	      }
	      mc = 'm';
	      ++i;
	   }
	}
      else if (luc != '~' && luc != '\0')
	{
	  commPutData ((char *) &luc, 1);
	  strncat (text,(char *) &luc, 1);
	  ++i;
	}

    }
put_tx_window (text);
}


// This will be called, when we hit a key.

gint
key_input (GtkWidget * widget, GdkEventKey * event)
{
  PSK31info rxinfo;


  if (event->state & GDK_MOD1_MASK) {/**/}

  else if (event->keyval == 65507)
	{
	set_button (1);
	ctrl_key_down = 1;
	}

  else if (event->keyval == 65293)
    {				// CR
	commPutData ("\n",1);
	put_tx_window ("\n");
    }
  else if (event->keyval == 65288)
    {				// Backspace
	commPutData ("\b",1); 
        delete_char_tx_window ();
    }
  else if (event->keyval == 65289)
    {
	/*
         * The keys that should be ingnored in this routine
         * Currently: TAB
         */
    }
  else if (event->keyval == 65480)
    {				// F-11
	    if (GTK_TOGGLE_BUTTON (main_screen.net)->active)
	      {
		commControl (COMM_TXCH, COMM_FREQ, (int)
			     (100 * gtk_spin_button_get_value_as_float
			      (GTK_SPIN_BUTTON (main_screen.rx_freq))));

		gtk_spin_button_set_value (GTK_SPIN_BUTTON
					   (main_screen.tx_freq),
					   gtk_spin_button_get_value_as_float
					   (GTK_SPIN_BUTTON
					    (main_screen.rx_freq)));
	      }
	      commControl (COMM_TXCH, COMM_MODE, MO_NORMAL);
	      commControl (COMM_TXCH, COMM_PTT, PTTON|PTTFORCE);
    }


  else if (event->keyval == 65481)
    {				// F-12
	if (GTK_TOGGLE_BUTTON (main_screen.cwid)->active) {
                    commControl (COMM_TXCH, COMM_MODE, MO_CWSEND);
                    commPutData ((char*) &ini_settings.cw_string, 0);
		}
	  commControl (COMM_TXCH, COMM_PTT, PTTOFF);
	  commControl (COMM_TXCH, COMM_MODE, MO_NORMAL);
    }

  else if (event->keyval >= 65470 && event->keyval <= 65477)
    {				// F1 <--> F8
      //macro_to_send = event->keyval - 65469;
      gtk_button_clicked (GTK_BUTTON (main_screen.f_button[event->keyval - 65470]));
    }

  else if (event->keyval == 65453)	// - update freq -1
    {
      commGetInfo (COMM_RXCH, &rxinfo, sizeof (rxinfo));
      commControl (COMM_TXCH, COMM_FREQ, (rxinfo.freq - 100));
      gtk_spin_button_set_value (GTK_SPIN_BUTTON (main_screen.rx_freq),
				 (0.01 * (rxinfo.freq - 100)));
    }

  else if (event->keyval == 65451)	// Right arrow - update freq +1
    {
      commGetInfo (COMM_RXCH, &rxinfo, sizeof (rxinfo));
      commControl (COMM_TXCH, COMM_FREQ, (rxinfo.freq + 100));
      gtk_spin_button_set_value (GTK_SPIN_BUTTON (main_screen.rx_freq),
				 (0.01 * (rxinfo.freq + 100)));
    }


   else {		// Now it should be the string we want to send
   commPutData (event->string, event->length);
   put_tx_window (event->string);
}
  return 0;
}

// This will be called, when we release a kex

int
key_released (GtkWidget * widget, GdkEventKey * event)
{
  if (event->keyval == 65507) {
	set_button (0);
	ctrl_key_down = 0;
	}
  return 0;
}



void
rx_freq_changed (GtkWidget * widget, GtkSpinButton * spin)	// Called, when we change the rx_freq
{
  commControl (COMM_RXCH, COMM_FREQ,
	       (int) (100 * (gtk_spin_button_get_value_as_float (spin))));
  gtk_widget_grab_focus (main_screen.rxwindow);
}

void
tx_freq_changed (GtkWidget * widget, GtkSpinButton * spin)	// same for tx freq
{
  commControl (COMM_TXCH, COMM_FREQ,
	       (int) (100 * (gtk_spin_button_get_value_as_float (spin))));
  gtk_widget_grab_focus (main_screen.rxwindow);
}

void
afc_toggled (GtkWidget * widget, gpointer data)	// afc changed....
{
  if (GTK_TOGGLE_BUTTON (widget)->active) {
    commControl (COMM_RXCH, COMM_AFC, 1);
    check_menu ("/Mode/AFC", 1);
    }
  else {
    commControl (COMM_RXCH, COMM_AFC, 0);
    check_menu ("/Mode/AFC", 0);
    }
}

void
net_toggled (GtkWidget * widget, gpointer data)	// net changed....
{
  if (GTK_TOGGLE_BUTTON (widget)->active)
    check_menu ("/Mode/NET", 1);
  else
    check_menu ("/Mode/NET", 0);
}

void
qpsk_toggled (GtkWidget * widget, gpointer data)	// mode (bpsk)
{
  if (GTK_TOGGLE_BUTTON (widget)->active)
    {
      commControl (COMM_RXCH, COMM_QPSK, 1);
      commControl (COMM_TXCH, COMM_QPSK, 1);
      gtk_statusbar_pop (GTK_STATUSBAR (statusbar.mode), 1);
      gtk_statusbar_push (GTK_STATUSBAR (statusbar.mode), 1, "QPSK");
      check_menu ("/Mode/QPSK", 1);
    }
	else {
	commControl (COMM_RXCH, COMM_QPSK, 0);
      commControl (COMM_TXCH, COMM_QPSK, 0);
      gtk_statusbar_pop (GTK_STATUSBAR (statusbar.mode), 1);
      gtk_statusbar_push (GTK_STATUSBAR (statusbar.mode), 1, "BPSK");
      check_menu ("/Mode/QPSK", 0);
    }
}

void cwid_toggled (GtkWidget * widget, gpointer data)
{
 if (GTK_TOGGLE_BUTTON (widget)->active)
    check_menu ("/Mode/CW-ID", 1);
  else
    check_menu ("/Mode/CW-ID", 0);
}





void
tx_clear_pressed (GtkWidget * widget, gpointer data)
{
	commControl (COMM_TXCH, COMM_PTT, PTTOFF|PTTFORCE);
}

void
tx_button_pressed (GtkWidget * widget, gpointer data)
{
	if (GTK_TOGGLE_BUTTON (main_screen.net)->active)
	  {
	    commControl (COMM_TXCH, COMM_FREQ, (int)
			 (100 * gtk_spin_button_get_value_as_float
			  (GTK_SPIN_BUTTON (main_screen.rx_freq))));

	    gtk_spin_button_set_value (GTK_SPIN_BUTTON (main_screen.tx_freq),
				       gtk_spin_button_get_value_as_float
				       (GTK_SPIN_BUTTON (main_screen.
							 rx_freq)));

	  }
	  commControl (COMM_TXCH, COMM_MODE, MO_NORMAL);
	  commControl (COMM_TXCH, COMM_PTT, PTTON|PTTFORCE);
}

void
rx_button_pressed (GtkWidget * widget, gpointer data)
{
	if (GTK_TOGGLE_BUTTON (main_screen.cwid)->active) {
                    commControl (COMM_TXCH, COMM_MODE, MO_CWSEND);
                    commPutData ((char *) &ini_settings.cw_string, 0);
	}
      commControl (COMM_TXCH, COMM_PTT, PTTOFF);
      commControl (COMM_TXCH, COMM_MODE, MO_NORMAL);
}


void dcd_level_changed (GtkAdjustment * adj)
{
	int d;
	d = (gint) (adj->value * -1);
	if (d != -1) d = d +1;	// dcd = 0 --> old dcd, we do not want that
	commControl (COMM_RXCH, COMM_DCDLEVEL, d);
}

void
selection_get (GtkWidget * widget, GdkEventButton * event)
{
  static GdkAtom strings_atom = GDK_NONE;
  if (event->button == 2)
    {
      gtk_text_backward_delete (GTK_TEXT (main_screen.txwindow), 1);
      if (strings_atom == GDK_NONE)
        strings_atom = gdk_atom_intern ("STRINGS", FALSE);
      gtk_selection_convert (widget, GDK_SELECTION_PRIMARY, strings_atom,
                             GDK_CURRENT_TIME);

    }
}

void
selection_received (GtkWidget * widget, GtkSelectionData * selection_data,
                    gpointer data)
{
  int i = 0;
  if (selection_data->data != NULL)
    {
      while (selection_data->data[i] != '\0')
        {
          commPutData ((char *) &selection_data->data[i], 1);
          ++i;
        }
    }
}

void
selection_get_draw_cursor (GtkWidget * widget, GdkEventButton * event)
{
  if (event->button == 2)
  put_tx_window_cursor ();
}
                                                             
