#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2005 Free Software Foundation
#
# FILE:
# informix/DBdriver.py
#
# DESCRIPTION:
# Driver to provide access to data via Alexander Kuznetsov's
# Informix/Python Driver  *  Requires Kinfxdb 0.2+
# (http://thor.prohosting.com/~alexan/pub/Kinfxdb/Kinfxdb-0.2.tar.gz)
#
# NOTES:
#
#     dbame=      This is the Informix database to use (required)
#     host=      This is the Informix host for your connection  (optional)
#

__all__ = ['Connection']

####                                   ####
#### IF YOU MODIFY ANY CONNECTION      ####
#### ATTRIBUTES, PLEASE UPDATE info.py ####
####                                   ####

from string import lower
import sys
from gnue.common.datasources import GDataObjects, GConditions, GConnections
from gnue.common.apps import GDebug
from gnue.common.datasources.drivers import DBSIG2

try:
  import informixdb as SIG2api
except ImportError:
  raise GConnections.DependencyError, ('Kinfxdb', None)


class Connection(DBSIG2.Connection):

  _driver = SIG2api
  _DatabaseError = SIG2api.DatabaseError
  supportedDataObjects = {
    'object': DataObject_Object,
    'sql':    DataObject_SQL
  }

  def connect(self, connectData={}):
    GDebug.printMesg(9,"Informix database driver initializing")
    try:
      if connectData.has_key('host') and len(connectData['host']):
        db = connectData['dbname'] + "@" + connectData['host']
      else:
        db = connectData['dbname']
      self.native = SIG2api.connect( \
                   dbname=connectData['dbname'], \
                   user=connectData['_username'], \
                   passwd=connectData['_password'])
    except self._DatabaseError, value:
      raise GDataObjects.LoginError, value

