#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2001-2005 Free Software Foundation
#
# FILE:
# csv/Connection.py
#
# DESCRIPTION:
# Static database driver for loading data from a CSV file
#
# NOTES:
# Requires Python >= 2.3


__all__ = ['Connection']

####                                   ####
#### IF YOU MODIFY ANY CONNECTION      ####
#### ATTRIBUTES, PLEASE UPDATE info.py ####
####                                   ####

import string
import os.path
import csv
from gnue.common.apps import GDebug
from gnue.common.datasources.drivers.Base.Connection import Connection as BaseConnection
from gnue.common.datasources.drivers.csv.Schema.Discovery.Introspection import Introspection
from DataObject import CSV_DataObject


class Csv_Error(StandardError):
  pass

class Connection(BaseConnection):
  defaultBehavior = Introspection
  supportedDataObjects = {'object': CSV_DataObject,
                           'static': CSV_DataObject} # TODO: Why static?!?
  _DatabaseError = Csv_Error

  # We don't do connections (we are connectionless)
  def connect(self, connectData={}):
    try:
      GDebug.printMesg(9,'Open file: %s' % (connectData['dbname']))
      self.native = csv.DictReader(file(connectData['dbname']),[])
    except IOError:
      tmsg = _('CSV file not found.')
      raise self._DatabaseError, tmsg
    except TypeError:
      tmsg = _('Wrong file format.')
      raise self._DatabaseError, tmsg

    # build fieldnames list
    self._reader = csv.reader(file(connectData['dbname']))
    if connectData.has_key('firstrowisheader'):
      self.native.fieldnames = map(string.lower, self.native.reader.next())
    else:
      self.native.fieldnames = ["x%s" % i for i in range(len(self._reader.next()))]

    self.native.fname = os.path.split(connectData['dbname'])[1]

  # no authentification required
  def getLoginFields(self):
    return []

