/* Generated by G-Wrap: an experimental C->Guile wrapper engine */

#include <guile/gh.h>
#include <libguile.h>
#include <string.h>
#include <g-wrap-compatibility.h>

#include "gw-core-utils.h"
#include <core-utils.h>
enum GW__ErrorStatus
{
  GW__ERR_NONE,
  GW__ERR_MISC,
  GW__ERR_MEMORY,
  GW__ERR_RANGE,
  GW__ERR_TYPE,
  GW__ERR_ARGC,
  GW__ERR_ARG_RANGE,
  GW__ERR_ARG_TYPE
};
 
static void
gw__handle_wrapper_error(enum GW__ErrorStatus status,
                         const char *func_name,
                         unsigned int arg_pos,
                         const char *misc_msg,
                         SCM scm_data) __attribute__ ((noreturn));

static void
gw__handle_wrapper_error(enum GW__ErrorStatus status,
                         const char *func_name,
                         unsigned int arg_pos,
                         const char *misc_msg,
                         SCM scm_data)
{
  static SCM out_of_range_key = SCM_BOOL_F;
  static SCM wrong_type_key = SCM_BOOL_F;

  if(SCM_FALSEP(out_of_range_key))
    out_of_range_key = scm_permanent_object(scm_c_make_keyword("out-of-range"));
  if(SCM_FALSEP(wrong_type_key))
    wrong_type_key = scm_permanent_object(scm_c_make_keyword("wrong-type"));

  switch(status) {
  case GW__ERR_NONE:
    scm_misc_error(func_name,
                   "asked to handle error when there wasn't one",
                   SCM_EOL);
    break;
  case GW__ERR_MISC:
    /* scm_data is a list of format args for misc_msg */
    scm_misc_error(func_name, misc_msg, scm_data); break;
  case GW__ERR_MEMORY:
    scm_memory_error(func_name); break;
  case GW__ERR_RANGE:
    scm_error (out_of_range_key,
	       func_name,
	       "Out of range: ~S",
               scm_cons (scm_data, SCM_EOL),
	       SCM_BOOL_F);
    break;
  case GW__ERR_TYPE:
    scm_error(wrong_type_key,
              func_name,
              "Wrong type: ",
              scm_cons (scm_data, SCM_EOL),
              SCM_BOOL_F);
    break;
  case GW__ERR_ARGC:
    scm_wrong_num_args(scm_makfrom0str(func_name)); break;
  case GW__ERR_ARG_RANGE:
    /* scm_data is the bad arg */
    scm_out_of_range(func_name, scm_data); break;
  case GW__ERR_ARG_TYPE:
    /* scm_data is the bad arg */
    scm_wrong_type_arg(func_name, arg_pos, scm_data); break;
  default:
    scm_misc_error(func_name,
                   "asked to handle nonexistent gw:error type: ~S",
                   scm_cons(scm_long2num(status), SCM_EOL));    
    break;
  };
  exit(1);
}
void
gw_init_wrapset_gw_core_utils() {
  static int gw_wrapset_initialized = 0;

  if(!gw_wrapset_initialized)
  {
    gh_eval_str("(use-modules (g-wrap runtime))");
    gh_eval_str("(gw:wrapset-register-runtime \"gw-core-utils\")");

{
   enum GW__ErrorStatus gw__tmp0_status_var = GW__ERR_NONE;
   SCM gw__tmp2_err_data = SCM_UNSPECIFIED;
   char *gw__tmp1_err_misc_msg = NULL;
   (void) gw__tmp0_status_var;
   (void) gw__tmp2_err_data;
   (void) gw__tmp1_err_misc_msg;
}
{
   enum GW__ErrorStatus gw__tmp3_err_status = GW__ERR_NONE;
   SCM gw__tmp5_err_data = SCM_UNSPECIFIED;
   char *gw__tmp4_err_misc_msg = NULL;
   (void) gw__tmp3_err_status;
   (void) gw__tmp5_err_data;
   (void) gw__tmp4_err_misc_msg;
}
{
   enum GW__ErrorStatus gw__tmp6_status_var = GW__ERR_NONE;
   SCM gw__tmp8_err_data = SCM_UNSPECIFIED;
   char *gw__tmp7_err_misc_msg = NULL;
   (void) gw__tmp6_status_var;
   (void) gw__tmp8_err_data;
   (void) gw__tmp7_err_misc_msg;
}
    gw_wrapset_initialized = 1;
    (void) gw__handle_wrapper_error;
  }
}
