/*  Gnometab -- a guitar tablature editor for GNOME
    Copyright (C) 2001  William L. Guelker

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif
#include <gnome.h>
#include "tab_canvas.h"
#include "tab_doc.h"
#include "interface.h"

int
main (int argc, char *argv[])
{
    GConfClient        *client;
    gboolean         lib_is_visible;
     gboolean         file_exists;
    gint             width, height;
    GtabApp         *app;
    GtabDoc         *new_doc;
    double             zoom;
    
#ifdef ENABLE_NLS
    bindtextdomain (PACKAGE, PACKAGE_LOCALE_DIR);
    textdomain (PACKAGE);
#endif

    gnome_program_init ("gnometab", VERSION, LIBGNOMEUI_MODULE, argc, argv,
                            GNOME_PARAM_POPT_TABLE, NULL,
                            NULL, NULL);
        
    client = gconf_client_get_default();
    gconf_client_add_dir(client, 
                        GCONF_PATH, 
                        GCONF_CLIENT_PRELOAD_NONE,
                        NULL);

    gnome_window_icon_set_default_from_file(PACKAGE_PIXMAPS_DIR"/gtab-icon.png");
 
    LIBXML_TEST_VERSION;
    
    chords_above_staff = gconf_client_get_bool(client, 
                                                GCONF_CHORDS_ABOVE_STAFF, 
                                                NULL);
    height = gconf_client_get_int(client, GCONF_WINDOWHEIGHT, NULL);
    width = gconf_client_get_int(client, GCONF_WINDOWWIDTH, NULL);
    
    app = create_gnometab ();
    new_doc = new_tab_doc(app);
    
    zoom = gconf_client_get_float(client, GCONF_ZOOMLEVEL, NULL);
    
    /* sanity checking */
    if (!zoom) { zoom = 1; }
    if (zoom > 1.4 || zoom < 0.8) { zoom = 1; }
    
    app->zoom_level = zoom;
    
    gnome_canvas_set_pixels_per_unit(GNOME_CANVAS(new_doc->tab_canvas), zoom);
    
    if (height && width) {
        gtk_window_resize(GTK_WINDOW(app->gnometab), width, height);
    }
    else {
        /* sane defaults */
        gtk_window_resize(GTK_WINDOW(app->gnometab), 800.0, 600.0);
    }
    
    refresh_fonts(app);
    
    /* gnome_appbar_set_default(GNOME_APPBAR(app->appbar), "GnomeTab"); */
    
    /* don't allow paste unless something's in the clipboard object buffer */
    gtk_widget_set_sensitive(GTK_WIDGET(g_object_get_data
                                        (G_OBJECT(new_doc->popup->menu), 
                                                        "paste_popup")),
                                        FALSE);
    
    create_staff(new_doc);
    
    new_doc->filename = NULL;
    
    set_pagenum(new_doc, 1);
    new_doc->properties = NULL;
    
    num_entry_bool = FALSE;
        
    staff_select = FALSE;
    
    lib_is_visible = gconf_client_get_bool(client, GCONF_CHORD_LIB_VISIBLE, NULL);
    load_chord_lib(app, NULL, lib_is_visible);
    
    
    app->current_tool = TOOL_POINTER;
    prior_tool = TOOL_POINTER;
    
    if (argc > 0)    {
        file_exists = g_file_test(argv[1], G_FILE_TEST_EXISTS && 
                                            G_FILE_TEST_IS_REGULAR);
        
        if (file_exists)     {
            new_doc->filename = g_strdup(argv[1]);
            file_pre_load(new_doc);
        }
    }

    app->current_doc = (gpointer )new_doc;
    
    gtk_widget_show (app->gnometab);
    
    gtk_main ();
    
    return 0;
}


                                    
