/* GnomerMind - A MasterMind(R)-based game for Gnome
 * (C) 2001 Germano Rizzo
 *
 * keyboard.c - keyboard control implementation
 * Author: Germano Rizzo
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "common.h"
#include "gnomermind.h"
#include "prefs.h"

guint key[KEY];
static gint idx = 0;
static gboolean custom = FALSE;

static gchar *cmd[] = {
  N_("Token"),
  N_("Position"),
  N_("Action")
};

/**
 * key_press
 * @widget: ignored, only for callback
 * @event: the GdkEventKey produced
 * @data: ignored, only for callback
 *
 * Manages the pression of a key in the keyboard
 **/
void
key_press (GtkWidget * widget, GdkEventKey * event, gpointer data)
{
  gint i;

  for (i = 0; i < KEY; i++)
    if (event->keyval == key[i])
      {
	if ((i < colorz))
	  manage (1, i + 1, 0);
	else if ((i >= MAXC) && (i < MAXC + holez))
	  manage (0, i - MAXC, -1);
	else if (i == 16)
	  manage (2, 0, 0);
	break;
      }
}

/**
 * gen_key_list
 *
 * Generates a list with the key binding names
 **/
GList *
gen_key_list ()
{
  GList *tmp;
  gint i;

  tmp = NULL;
  tmp = g_list_prepend (tmp, _(cmd[2]));
  for (i = MAXH; i > 0; i--)
    tmp = g_list_prepend (tmp, g_strdup_printf ("%s %d", _(cmd[1]), i));
  for (i = MAXC; i > 0; i--)
    tmp = g_list_prepend (tmp, g_strdup_printf ("%s %d", _(cmd[0]), i));

  return tmp;
}

/**
 * parse_list
 * @needle: the string to search
 *
 * Gives the key[] index of a (i18n'd) string
 **/
static gint
parse_list (gchar * needle)
{
  gint i;

  for (i = 0; i < KEY; i++)
    {
      if (i < MAXC)
	{
	  if (!g_strcasecmp
	      (g_strdup_printf ("%s %d", _(cmd[0]), i + 1), needle))
	    return i;
	}
      else if (i < MAXC + MAXH)
	{
	  if (!g_strcasecmp
	      (g_strdup_printf ("%s %d", _(cmd[1]), i - MAXC + 1),
	       needle)) return i;
	}
      else if (!g_strcasecmp (_(cmd[2]), needle))
	return KEY - 1;
    }
  return -1;
}

/**
 * key_get
 *
 * Gives the current key
 **/
inline guint
key_get ()
{
  return key[idx];
};

/**
 * key_sel
 * @widget: ignored, only for callback
 * @data: the selected string
 *
 * Manages a GtkOptionsMenu selection
 **/
void
key_sel (GtkWidget * widget, gpointer data)
{
  idx = parse_list (data);
  custom = FALSE;
  if (idx == -1)
    kd_upd (_("Invalid"));
  else
    kd_upd (gdk_keyval_name (key[idx]));
}

/**
 * key_grab_release
 *
 * Release the grab
 **/
void
key_grab_release ()
{
  if (custom)
    {
      gdk_keyboard_ungrab (GDK_CURRENT_TIME);
      custom = FALSE;
      kd_upd (gdk_keyval_name (key[idx]));
    }
};

/**
 * key_new_press
 * @widget: ignored, only for callback
 * @event: the GdkEventKey produced
 * @data: ignored, only for callback
 *
 * Manages the pression of a key in the keyboard
 **/
void
key_new_press (GtkWidget * widget, GdkEventKey * event, gpointer data)
{
  if (custom)
    {
      gint i;
      gboolean key_available = TRUE;

      key_grab_release ();

      for (i = 0; i < KEY; i++)
	if ((key[i] == event->keyval))
	  key_available = FALSE;

      if ((key_available) || (event->keyval == key[idx]))
	{
	  key[idx] = event->keyval;
	  kd_upd (gdk_keyval_name (key[idx]));
	}
      else
	kd_upd (_("Key in use!"));
    }
}

/**
 * key_new
 * @widget: the select button pressed
 * @data: ignored, only for callback
 *
 * Used when the `set new key' button is clicked
 **/
void
key_new (GtkWidget * widget, gpointer data)
{
  if (idx > -1)
    {
      if (custom)
	key_grab_release ();
      else
	{
	  gdk_keyboard_grab (GTK_WIDGET (widget)->window, TRUE,
			     GDK_CURRENT_TIME);
	  custom = TRUE;
	  kd_upd (_("Strike a key!"));
	}
    }
}
