/* GNOME DB library
 * Copyright (C) 1998-2001 The Free Software Foundation
 *
 * Authors:
 *	Michael Lausch <michael@lausch.at>
 *	Rodrigo Moya <rodrigo@gnome-db.org>
 *
 * This Library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this Library; see the file COPYING.LIB.  If not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __gnome_db_logindlg_h__
#define __gnome_db_logindlg_h__ 1

#include <libgnomeui/gnome-dialog.h>
#include <gda-connection.h>
#include <gnome-db-error-dlg.h>
#include <gnome-db-login.h>

BEGIN_GNOME_DECLS

#define GNOME_DB_TYPE_LOGINDLG            (gnome_db_logindlg_get_type())
#define GNOME_DB_LOGINDLG(obj)            (GTK_CHECK_CAST((obj), GNOME_DB_TYPE_LOGINDLG, GnomeDbLoginDlg))
#define GNOME_DB_LOGINDLG_CLASS(klass)    (GTK_CHECK_CLASS_CAST ((klass), GNOME_DB_TYPE_LOGINDLG, GnomeDbLoginDlgClass))
#define GNOME_DB_IS_LOGINDLG(obj)         GTK_CHECK_TYPE(obj, GNOME_DB_TYPE_LOGINDLG)
#define GNOME_DB_IS_LOGINDLG_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), GNOME_DB_TYPE_LOGINDLG))

typedef struct _GnomeDbLoginDlg           GnomeDbLoginDlg;
typedef struct _GnomeDbLoginDlgClass      GnomeDbLoginDlgClass;

struct _GnomeDbLoginDlg
{
	GnomeDialog         dialog;
	GnomeDbLogin*       login;
	GnomeDbErrorDialog* error;
};

struct _GnomeDbLoginDlgClass
{
	GnomeDialogClass parent_class;
	void             (*login)(GnomeDbLoginDlg* login);
	void             (*cancel)(GnomeDbLoginDlg* login);
};

GtkType    gnome_db_logindlg_get_type (void);

GtkWidget* gnome_db_logindlg_new      (GnomeDbLogin* login, gchar* title);
void       gnome_db_logindlg_popup    (GnomeDbLoginDlg* dialog);

END_GNOME_DECLS

#endif
