/*
    GNOME Commander - A GNOME based file manager 
    Copyright (C) 2001-2003 Marcus Bjurman

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/ 
#ifndef __GNOME_CMD_FILE_SELECTOR_FUNCS_H__
#define __GNOME_CMD_FILE_SELECTOR_FUNCS_H__

#include "gnome-cmd-file-selector-types.h"
#include "gnome-cmd-connection-types.h"
#include "gnome-cmd-dir-types.h"


GtkType
gnome_cmd_file_selector_get_type         (void);

GtkWidget*
gnome_cmd_file_selector_new              (void);

GnomeCmdDir*
gnome_cmd_file_selector_get_directory    (GnomeCmdFileSelector *fs);

gboolean
gnome_cmd_file_selector_set_directory    (GnomeCmdFileSelector *fs,
										  GnomeCmdDir *dir);

void
gnome_cmd_file_selector_goto_directory   (GnomeCmdFileSelector *fs,
										  const gchar *dir);

void
gnome_cmd_file_selector_reload           (GnomeCmdFileSelector *fs);

void
gnome_cmd_file_selector_start_editor      (GnomeCmdFileSelector *fs);

void
gnome_cmd_file_selector_back             (GnomeCmdFileSelector *fs);

void
gnome_cmd_file_selector_forward           (GnomeCmdFileSelector *fs);

gboolean
gnome_cmd_file_selector_can_back          (GnomeCmdFileSelector *fs);

gboolean
gnome_cmd_file_selector_can_forward       (GnomeCmdFileSelector *fs);

GnomeVFSURI*
gnome_cmd_file_selector_get_directory_uri (GnomeCmdFileSelector *fs);

void
gnome_cmd_file_selector_set_active       (GnomeCmdFileSelector *fs,
										  gboolean value);

void
gnome_cmd_file_selector_update_connections (GnomeCmdFileSelector *fs);

gboolean
gnome_cmd_file_selector_set_connection (GnomeCmdFileSelector *fs,
										GnomeCmdConnection *con,
										GnomeCmdDir *start_dir);

GnomeCmdConnection*
gnome_cmd_file_selector_get_connection (GnomeCmdFileSelector *fs);

void
gnome_cmd_file_selector_update_style (GnomeCmdFileSelector *fs);

void
gnome_cmd_file_selector_show_mkdir_dialog (GnomeCmdFileSelector *fs);

void
gnome_cmd_file_selector_show_new_textfile_dialog (GnomeCmdFileSelector *fs);

void
gnome_cmd_file_selector_cap_paste (GnomeCmdFileSelector *fs);

gboolean
gnome_cmd_file_selector_keypressed (GnomeCmdFileSelector *fs,
									GdkEventKey *event);

void
gnome_cmd_file_selector_create_symlink (GnomeCmdFileSelector *fs, GnomeCmdFile *finfo);

#endif //__GNOME_CMD_FILE_SELECTOR_FUNCS_H__


