%define name	gnomad2
%define version 2.5.0
%define release 1
# Release scheme for different RPM-based distributions:
# release = "1" for distro-independent stuff like source packages
# release = "1.rh9" - release 1 for Red Hat Linux 9
# release = "1.FC1" -release 1 for Fedora Core Linux 1
%define prefix  /usr

# Considering that there is no reliable distribution of id3lib and
# libnjb, I usually link these statically by commenting them out
# below. This involves particular building procedures:
#
# First install id3lib and libnjb from source or packages, then
# break your packages :-) thusly:
#
# rm /usr/local/lib/libnjb.so*
# rm /usr/local/lib/libid3*so*
#
# The build will then automatically link to the static .a files
# instead. I haven't found any better way to do this unfortunately.

Summary:	Gnomad 2 is a Linux/BSD GNOME 2.0 client for the Nomad Jukebox
Name:		%{name}
Version:    	%{version}
Release:	%{release}
Copyright:	GPL
URL:		http://gnomad2.sourceforge.net
Group:		Applications/Multimedia
Source0:	%{name}-%{version}.tar.gz
Packager:       Linus Walleij <triad@df.lth.se>
BuildRoot:	%{_builddir}/%{name}-%{version}-root
Requires:       glib2 >= @GLIB_REQUIRED@
Requires:       gtk2 >= @GTK_REQUIRED@
Requires:	libgnome >= @LIBGNOME_REQUIRED@
Requires:	libgnomeui >= @LIBGNOMEUI_REQUIRED@
Requires:	libusb >= 0.1.5
Requires:	libstdc++
Requires:	zlib
BuildRequires:	glib2-devel >= @GLIB_REQUIRED@
BuildRequires:	gtk2-devel >= @GTK_REQUIRED@
BuildRequires:	libgnome-devel >= @LIBGNOME_REQUIRED@
BuildRequires:	libgnomeui-devel >= @LIBGNOMEUI_REQUIRED@
BuildRequires:	libusb-devel >= 0.1.5
#BuildRequires: libnjb
#BuildRequires:	id3lib-devel >= 3.8.0
Docdir:         %{prefix}/share/doc
Prefix:		%{_prefix}

%description
Gnomad 2 is a client for the Nomad Jukebox utilizing the
libnjb library for jukebox communication. It is used for
storing MP3 (and WAV, WMA) files on the jukebox and
retrieving them again, it also handles data file storage
and retrieval, playlists and a rudimentary player
with full support for the Creative EAX sound processor.

%prep
%setup 

%build
%configure
make RPM_OPT_FLAGS="$RPM_OPT_FLAGS"

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/etc/hotplug/usb
make DESTDIR=$RPM_BUILD_ROOT install
# install hotplug scripts so they are up to date
install -m 755 nomadjukebox $RPM_BUILD_ROOT/etc/hotplug/usb
install -m 644 nomad.usermap $RPM_BUILD_ROOT/etc/hotplug/usb

%post
# This is much because RedHat use an old hotplug version that
# doesn't recognize the personalized usermap properly.
function inmap {
    while read LINE; do
	if [ "x${LINE}" != "x" ]; then
	    firstword=`echo ${LINE} | awk '{ print $1 }'`
	    if [ ${firstword} != "#" ]; then
		script=${firstword}
		manid=`echo ${LINE} | awk '{ print $3 }'`
		productid=`echo ${LINE} | awk '{ print $4 }'`
		if [ "x${script}" = "x$2" ]; then 
		    if [ "x${manid}" = "x$3" ]; then 
			if [ "x${productid}" = "x$4" ]; then
			    echo "yes"
			    return 0
			fi
		    fi
		fi
	    fi
	fi
    done < $1
    echo "no"
    return 0
}
function patchusermap {
    comment=""
    while read LINE; do
	if [ "x$LINE" != "x" ]; then
	    firstword=`echo ${LINE} | awk '{ print $1 }'`
	    if [ ${firstword} = "#" ]; then
		comment=${LINE}
	    else
		script=${firstword}
		manid=`echo ${LINE} | awk '{ print $3 }'`
		productid=`echo ${LINE} | awk '{ print $4 }'`
		if [ "x${manid}" != "x" ]; then
		    echo "Checking for product ${productid} in $2..."
		    if [ `inmap $2 ${script} ${manid} ${productid}` = "no" ]; then
			echo "Not present, adding to hotplug map."
			echo ${LINE} >> $2
			comment=""
		    else
			echo "Already installed."
		    fi
		fi
	    fi
	fi
    done < $1
}
# echo "Checking hotplugging CVS version..."
# echo "/etc/hotplug/usb/*.usermap support was added in august 2002"
EDITMAP="yes"
CVSTAG=`grep '\$Id:' /etc/hotplug/usb.agent`
if [ "x${CVSTAG}" != "x" ]; then
    DATE=`echo ${CVSTAG} | awk '{ print $5 }'`
    # echo "Hotplug version seems to be from ${DATE}"
    YEAR=`echo ${DATE} | awk 'BEGIN { FS="/"} {print $1; }'`
    MONTH=`echo ${DATE} | awk 'BEGIN { FS="/"} {print $2; }'`
    DAY=`echo ${DATE} | awk 'BEGIN { FS="/"} {print $3; }'`
    if [ "${YEAR}" -gt "2002" ]; then
	EDITMAP="no"
    else
	if [ "${YEAR}" -eq "2002" ]; then
	    if [ "${MONTH}" -ge "08" ]; then
		EDITMAP="no"
	    fi
	fi
    fi
fi
if [ "x${EDITMAP}" = "xyes" ]; then
    echo "We need to edit the ${HOTPLUGPATH}/usb.usermap if it exists..."
    patchusermap /etc/hotplug/usb/nomad.usermap /etc/hotplug/usb.usermap
else
    # echo "No need to edit the ${HOTPLUGPATH}/usb.usermap file."
fi

%postun
# Remove entries from the usermap? What if someone has installed
# another program or from source? No way. See if the "nomadjukebox"
# script is still there, else remove the entries.
if test -f /etc/hotplug/usb/nomadjukebox
then
    # Nothing
    # echo "Nothing to remove from usb.usermap."
else
    # echo "Checking hotplugging CVS version..."
    # echo "/etc/hotplug/usb/*.usermap support was added in august 2002"
    EDITMAP="yes"
    CVSTAG=`grep '\$Id:' /etc/hotplug/usb.agent`
    if [ "x${CVSTAG}" != "x" ]; then
    	DATE=`echo ${CVSTAG} | awk '{ print $5 }'`
    	# echo "Hotplug version seems to be from ${DATE}"
    	YEAR=`echo ${DATE} | awk 'BEGIN { FS="/"} {print $1; }'`
    	MONTH=`echo ${DATE} | awk 'BEGIN { FS="/"} {print $2; }'`
    	DAY=`echo ${DATE} | awk 'BEGIN { FS="/"} {print $3; }'`
    	if [ "${YEAR}" -gt "2002" ]; then
		EDITMAP="no"
	else
		if [ "${YEAR}" -eq "2002" ]; then
	    		if [ "${MONTH}" -ge "08" ]; then
				EDITMAP="no"
	    		fi
		fi
    	fi
    fi
    if [ "x${EDITMAP}" = "xyes" ]; then
	# Remove any hotplug refs this hairy way
    	grep ^'[^n][^o][^m][^a][^d][^j][^u][^k][^e][^b][^o][^x]' /etc/hotplug/usb.usermap > /tmp/gnomad2.tmp
    	mv /tmp/gnomad2.tmp /etc/hotplug/usb.usermap
    	echo "Removed jukebox entries from usb.usermap."
    else
	# echo "No need to remove any usb.usermap entries."
    fi
fi


%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%{_bindir}/gnomad2
%{_datadir}/applications/gnomad2.desktop
%{_datadir}/locale/*/LC_MESSAGES/gnomad2.mo
%{_datadir}/application-registry/gnomad2.applications
%{_datadir}/pixmaps/gnomad2-logo.png
%dir /etc/hotplug/usb
%config(noreplace) /etc/hotplug/usb/*
%doc AUTHORS NEWS README COPYING

%changelog
* Wed Sep 29 2004 Linus Walleij <triad@df.lth.se> 2.5.0-1
- Lots of cool features, libnjb 1.2 CVS version needed
* Thu Apr 29 2004 Linus Walleij <triad@df.lth.se> 2.4.4-1
- Bug fixes, compilation on Gnome 2.5/2.6, libnjb 1.1
* Sat Apr 10 2004 Linus Walleij <triad@df.lth.se> 2.4.3-1
- Minor bug fixes, syncing up with some libnjb fixes.
* Mon Feb 22 2004 Linus Walleij <triad@df.lth.se> 2.4.2-1
- Minor bug fixes, syncing up with some libnjb fixes.
* Thu Jan 22 2004 Linus Walleij <triad@df.lth.se> 2.4.1-1
- Bug fixes, mainly NJB1 works again :-)
* Sat Jan 10 2004 Linus Walleij <triad@df.lth.se> 2.4.0-1
- Dell Digital Jukebox support, and syncs with CVS libnjb.
* Sat Dec 06 2003 Linus Walleij <triad@df.lth.se> 2.3.0-1
- Nomad Zen Xtra support, and sync to libnjb 1.0
* Mon Oct 27 2003 Linus Walleij <triad@df.lth.se> 2.2.0-1
- Nomad Zen NX support and full GTK+-2.0 migration.
* Sun Aug 10 2003 Linus Walleij <triad@df.lth.se> 2.1.0-2
- Relinking with updated version of libnjb.
* Sun Aug 10 2003 Linus Walleij <triad@df.lth.se> 2.1.0-1
- Several enhancements including stuff in libnjb.
* Thu May 22 2003 Linus Walleij <triad@df.lth.se> 2.0.2-1
- Making an RPM with minor bug fixes and some upgrade libnjb code.
* Sun Apr 20 2003 Linus Walleij <triad@df.lth.se> 2.0.1-2_rh9
- Fixing up a clean and working post script for the hotplugging
* Sat Apr 19 2003 Linus Walleij <triad@df.lth.se> 2.0.1-1_rh9
- Creating a RedHat 9 special, adding automated hotplug installation.
* Sun Mar 30 2003 Linus Walleij <triad@df.lth.se> 2.0.1
- Some fixes. Still relying on CVS version of libnjb.
* Thu Jan 16 2003 Linus Walleij <triad@df.lth.se> 2.0.0
- Skipped alpha. Going to sharp.
* Sun Jan 12 2003 Linus Walleij <triad@df.lth.se> 2.0.0a-1
- Initial alpha release of 2.0.0
* Mon Oct 07 2002 Linus Walleij <triad@df.lth.se> 1.1.6-1
- Bugfixes and preliminary NJB3 support
* Sat Sep 07 2002 Linus Walleij <triad@df.lth.se> 1.1.5-1
- Bugfixes again
* Fri Jul 19 2002 Linus Walleij <triad@df.lth.se> 1.1.4-1
- Bugfix release
* Tue Jun 18 2002 Linus Walleij <triad@df.lth.se> 1.1.3-1
- Bugfix release
* Sat Jun 1 2002 Linus Walleij <triad@df.lth.se> 1.1.2-1
- Another packaging.
* Sat Apr 6 2002 Linus Walleij <triad@df.lth.se> 1.1.0-1
- First try at a GNOMAD RPM package.
