/******************************************************************************\
 gnofin/ui-toolbar.c   $Revision: 1.6 $
 Copyright (C) 1999-2000 Darin Fisher

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\******************************************************************************/

#include "common.h"
#include <libgnomeui/gnome-app.h>
#include <libgnomeui/gnome-app-helper.h>
#include <libgnomeui/gnome-stock.h>
#include "ui.h"
#include "ui-toolbar.h"
#include "data-if.h"


/******************************************************************************
 * Signal handlers
 */

static void
on_file_save (GtkWidget *w, UI_Toolbar *toolbar)
{
  trace ("");
  g_return_if_fail (toolbar);

  ui_save_file (toolbar->ui, toolbar->ui->filename);
}

static void
on_edit_undo (GtkWidget *w, UI_Toolbar *toolbar)
{
  trace ("");
  g_return_if_fail (toolbar);
  g_return_if_fail (toolbar->ui);

  if (toolbar->ui->book)
    if_bankbook_undo (toolbar->ui->book);
}

static void
on_edit_redo (GtkWidget *w, UI_Toolbar *toolbar)
{
  trace ("");
  g_return_if_fail (toolbar);
  g_return_if_fail (toolbar->ui);

  if (toolbar->ui->book)
    if_bankbook_redo (toolbar->ui->book);
}

static void
on_record_delete (GtkWidget *w, UI_Toolbar *toolbar)
{
  trace ("");
  g_return_if_fail (toolbar);

  ui_remove_current_record (toolbar->ui);
}

static void
on_record_toggle_status (GtkWidget *w, UI_Toolbar *toolbar)
{
  trace ("");
  g_return_if_fail (toolbar);

  ui_toggle_current_record_status (toolbar->ui);
}

static void
on_file_exit (GtkWidget *w, UI_Toolbar *toolbar)
{
  trace ("");
  ui_exit (toolbar->ui);
}


/******************************************************************************
 * Helper functions
 */

static void
get_toolbar_buttons (UI_Toolbar *toolbar)
{
  /* get pointers to toolbar buttons */

  GnomeDockItem *item;
  GtkWidget *bar;
  gint i;

  const struct 
  {
    GtkWidget **ptr;
    gint position;
  }
  tools[] =
  {
    { &toolbar->file_save,	      0 },   /* be careful here !! */
    { &toolbar->edit_undo,	      2 },
    { &toolbar->edit_redo,	      3 },
    { &toolbar->record_delete,	      4 },
    { &toolbar->record_toggle_status, 5 },
  };

  trace ("");
  g_return_if_fail (toolbar);
  g_return_if_fail (toolbar->ui);

  item = gnome_dock_get_item_by_name (GNOME_DOCK (GNOME_APP (toolbar->ui->app)->dock),
				      GNOME_APP_TOOLBAR_NAME,
				      NULL, NULL, NULL, NULL);
  bar = gnome_dock_item_get_child (GNOME_DOCK_ITEM (item));

  for (i=0; i<sizeof_array(tools); ++i)
  {
    GtkToolbarChild * child;
    GList * node;

    node = g_list_nth (GTK_TOOLBAR (bar)->children, tools[i].position);
    child = LIST_DEREF (GtkToolbarChild, node);
    g_assert (child->type == GTK_TOOLBAR_CHILD_BUTTON);
    tools[i].ptr[0] = child->widget;
  }
}


/******************************************************************************
 * Interface functions
 */

UI_Toolbar *
ui_toolbar_create (UI *ui)
{
  UI_Toolbar *toolbar;

  trace ("");

  toolbar = g_new0 (UI_Toolbar, 1);
  toolbar->ui = ui;

  {
    GnomeUIInfo bar[] =
    {
      { GNOME_APP_UI_ITEM, NULL, N_("Save accounts"),
        on_file_save, toolbar, NULL,
        GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_SAVE, 0, 0, NULL },
      GNOMEUIINFO_SEPARATOR,
      { GNOME_APP_UI_ITEM, NULL, N_("Undo modification"),
        on_edit_undo, toolbar, NULL,
        GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_UNDO, 0, 0, NULL },
      { GNOME_APP_UI_ITEM, NULL, N_("Redo modification"),
        on_edit_redo, toolbar, NULL,
        GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_REDO, 0, 0, NULL },
     // GNOMEUIINFO_SEPARATOR,
      { GNOME_APP_UI_ITEM, NULL, N_("Delete selected record"),
        on_record_delete, toolbar, NULL,
        GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_CLOSE, 0, 0, NULL },
      { GNOME_APP_UI_ITEM, NULL, N_("Toggle cleared status of selected record"),
        on_record_toggle_status, toolbar, NULL,
	GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_CLEAR, 0, 0, NULL },
      GNOMEUIINFO_SEPARATOR,
      { GNOME_APP_UI_ITEM, NULL, N_("Exit (close this window)"),
        on_file_exit, toolbar, NULL,
        GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_EXIT, 0, 0, NULL },
      GNOMEUIINFO_END
    };
    gnome_app_create_toolbar (GNOME_APP (ui->app), bar);
  }

  get_toolbar_buttons (toolbar);
  return toolbar;
}

void
ui_toolbar_enable_save (UI_Toolbar *toolbar, gboolean enable)
{
  trace ("");
  g_return_if_fail (toolbar);

  gtk_widget_set_sensitive (toolbar->file_save, enable);
}

void
ui_toolbar_enable_undo (UI_Toolbar *toolbar, gboolean enable)
{
  trace ("");
  g_return_if_fail (toolbar);

  gtk_widget_set_sensitive (toolbar->edit_undo, enable);
}

void
ui_toolbar_enable_redo (UI_Toolbar *toolbar, gboolean enable)
{
  trace ("");
  g_return_if_fail (toolbar);

  gtk_widget_set_sensitive (toolbar->edit_redo, enable);
}

void
ui_toolbar_enable_record_ops (UI_Toolbar *toolbar, gboolean enable)
{
  trace ("");
  g_return_if_fail (toolbar);

  gtk_widget_set_sensitive (toolbar->record_delete, enable);
  gtk_widget_set_sensitive (toolbar->record_toggle_status, enable);
}
