/******************************************************************************\
 gnofin/plugin.c   $Revision: 1.3 $
 Copyright (C) 1999-2000 Darin Fisher

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\******************************************************************************/

/*
 * Sample plugin demostration
 *
 * Author:
 *   Darin Fisher (dfisher@jagger.me.berkeley.edu)
 */

#include "common.h"
#include "dialogs.h"
#include "plugin.h"
#include "gnofin-api.h"
#include "file-filter.h"
#include "text-export.h"

static void
free_plugin (PluginData *pd)
{
  trace ("");
  g_free (pd->private_data);
}

gint
init_plugin (PluginData *pd)
{
  FileFilter *filt;
  guint maj, min;

  trace ("libtext");

  /* Verify gnofin API version */
  gnofin_api_version_get (&maj, &min);
  if ((maj != GNOFIN_API_VERSION_MAJOR) || (min  < GNOFIN_API_VERSION_MINOR))
    return PLUGIN_ERROR_INVALID_API;

  /* Initialize PluginData structure */
  pd->free_plugin = free_plugin;
  pd->description = _("Tab-delimited text export plugin");
  pd->author = "Darin Fisher <dfisher@jagger.me.berkeley.edu>";

  /* Register a file importer */
  filt = g_new0 (FileFilter, 1);
  filt->label = _("Tab-delimited text");
  filt->export = text_export;
  file_filter_register (filt);

  /* Remember our importer structure */
  pd->private_data = (gpointer) filt;

  return PLUGIN_OK;
}

