#!/bin/sh

L=$1
C=$2

if [ "$L" = . ]; then
    awk -f ../../tools/help2man.awk ../../README | sed 's/gliv/\\fIgliv\\fR/g'
    exit $?
fi

if [ -z "$C" ]; then
    C=cat
fi

TEMP_DIR=/tmp/gliv-$$.$RANDOM
DIR=$L/LC_MESSAGES/

mkdirhier "${TEMP_DIR}/${DIR}" &&
cp ../../po/${L}.gmo "${TEMP_DIR}/${DIR}/gliv.mo"

export TEXTDOMAINDIR="$TEMP_DIR" LANGUAGE="$L"

awk -f ../../tools/help2man.awk ../../README |
while read LINE; do
    if [ "$LINE" = "" ] || [ "$LINE" = ".br" ]; then
        echo "$LINE"
    else
        gettext gliv "$LINE" | sed 's/gliv/\\fIgliv\\fR/g'
        echo
    fi
done | $C

rm -fr "$TEMP_DIR"
