#include <GL/gl.h>
#include "gliv.h"

#if HAVE_ISO_C_VARARGS

#include "gl_widget.h"

#define OPENGL_VOID_CALL_VOID(func)                             \
    do {                                                        \
        func();                                                 \
        report_opengl_errors(#func, __FILE__, __LINE__, 0);     \
    } while (0)

#define OPENGL_VOID_CALL(func, ...)                             \
    do {                                                        \
        func(__VA_ARGS__);                                      \
        report_opengl_errors(#func, __FILE__, __LINE__, 0);     \
    } while (0)

#define OPENGL_CALL(return_t, func, ...)                        \
    ({                                                          \
        return_t res = func(__VA_ARGS__);                       \
        report_opengl_errors(#func, __FILE__, __LINE__, 0);     \
        res;                                                    \
    })

/* Special cases ... */

#define glBegin(mode)                                           \
    do {                                                        \
        glBegin(mode);                                          \
        report_opengl_errors("glBegin", __FILE__, __LINE__, 1); \
    } while (0)

#define glEnd()                                                 \
    do {                                                        \
        glEnd();                                                \
        report_opengl_errors("glEnd", __FILE__, __LINE__, -1);  \
    } while (0)

#include "opengl_wrapper.h"
#else
#warning "No variadic macros"
#endif
