// T3QM1DOCV.CPP

// Copyright (C) 2000 Tommi Hassinen, Geoff Hutchison.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "t3qm1docv.h"

#include "setup_qm1_dialog.h"
#include "geomopt_dialog.h"

#include "t3main.h"
#include "t3dialog.h"
#include "t3errutil.h"
#include "t3views.h"

#include "qm1e_mopac.h"
#include "qm1e_mpqc.h"

#include "plane.h"
#include "surface.h"

#include "color.h"
#include "views.h"

#include <fstream>
using namespace std;

/*################################################################################################*/

const char qm1_file_open_dialog::title[] = "Open Project File";
gnome_qm1_docv * qm1_file_open_dialog::docv = NULL;

qm1_file_open_dialog::qm1_file_open_dialog(gnome_qm1_docv * p1) : file_dialog(title, NULL, NULL)
{
	docv = p1;
}

qm1_file_open_dialog::~qm1_file_open_dialog(void)
{
}

bool qm1_file_open_dialog::OkEvent(const char * filename)
{
	if (docv == NULL)
	{
		docv = new gnome_qm1_docv(& cout, * gnome_class_factory::GetInstance());
		docv->InitGnomeMDIChild();
	}
	
	bool open = !docv->atom_list.size();	// open, not insert
	
	ifstream ifile;
	ifile.open(filename, ios::in);
	docv->ReadStream(ifile, !open);		// was !open
	ifile.close();
	
	if (open) 	// we're "switching" to this file
	{
		docv->ParseProjectFileNameAndPath(filename);
		
		gnome_mdi_child_set_name(GNOME_MDI_CHILD(docv->child), docv->GetProjectFileName(true));
		docv->UpdateAllWindowTitles();
	}
	else		// we append this file to the current project
	{
		if (docv->selected_object != NULL)		// if an object was selected,
		{						// remove that selection and leave
			docv->selected_object = NULL;		// the newly added atoms as selection;
			docv->event_SelectedObjectChanged();	// now the mouse tools also affect the
		}						// newly added atoms!
	}
	
	docv->UpdateAllGraphicsViews();
	return true;
}

void qm1_file_open_dialog::CancelEvent(void)
{
}

/*################################################################################################*/

const char qm1_file_save_dialog::title[] = "Save Project File";
gnome_qm1_docv * qm1_file_save_dialog::docv = NULL;

qm1_file_save_dialog::qm1_file_save_dialog(gnome_qm1_docv * p1) : file_dialog(title, NULL, NULL)
{
	docv = p1;
}

qm1_file_save_dialog::~qm1_file_save_dialog(void)
{
}

bool qm1_file_save_dialog::OkEvent(const char * filename)
{
	if (docv == NULL)
	{
	  docv->err->ErrorMessage("qm1_file_save_dialog::OkEvent() failed");
	  exit(EXIT_FAILURE);
	}
	
  	// should check to see if file already exists...

	docv->ParseProjectFileNameAndPath(filename);
	
	gnome_mdi_child_set_name(GNOME_MDI_CHILD(docv->child), docv->GetProjectFileName(true));
	docv->UpdateAllWindowTitles();
	
	ofstream ofile;
	ofile.open(docv->GetFullProjectFileName(), ios::out);
	docv->WriteStream(ofile);
	ofile.close();

	return true;
}

void qm1_file_save_dialog::CancelEvent(void)
{
}

/*################################################################################################*/

GnomeUIInfo gnome_qm1_docv::filext_submenu[] =
{
//	GNOMEUIINFO_ITEM("no operation!", "???",
//		popup_FileExtra1, NULL),
		
	GNOMEUIINFO_END
};

GnomeUIInfo gnome_qm1_docv::file_submenu[] =
{
	GNOMEUIINFO_MENU_OPEN_ITEM(popup_FileOpen, NULL),
	
	GNOMEUIINFO_SEPARATOR,
	
	GNOMEUIINFO_MENU_SAVE_AS_ITEM(popup_FileSaveAs, NULL),
	
	GNOMEUIINFO_SEPARATOR,

	GNOMEUIINFO_SUBTREE("Extra Tools", filext_submenu),

	GNOMEUIINFO_SEPARATOR,
	
	GNOMEUIINFO_MENU_CLOSE_ITEM(gnome_graphics_view::popup_FileClose, NULL),
	
	GNOMEUIINFO_END
};

GnomeUIInfo gnome_qm1_docv::select_submenu[] =
{
	GNOMEUIINFO_ITEM("Select All", "select all atoms...",
		gnome_graphics_view::popup_SelectAll, NULL),

	GNOMEUIINFO_ITEM("Select All", "select all atoms...",
		gnome_graphics_view::popup_SelectNone, NULL),
		
	GNOMEUIINFO_ITEM("Invert Selection", "invert the selection...",
		gnome_graphics_view::popup_InvertSelection, NULL),
		
	GNOMEUIINFO_END
};

GnomeUIInfo gnome_qm1_docv::settings_submenu[] =
{
	GNOMEUIINFO_ITEM("Set Current Element", "el...",
		gnome_mdi_app::shortcut_Element, NULL),
		
	GNOMEUIINFO_END
};

GnomeUIInfo gnome_qm1_docv::viewscreate_submenu[] =
{
	GNOMEUIINFO_ITEM("New Camera", "create a new view with a new camera...",
		gnome_graphics_view::popup_ViewsNewCam, NULL),
		
	GNOMEUIINFO_ITEM("New View", "create a new view using the current camera...",
		gnome_graphics_view::popup_ViewsNewView, NULL),
		
	GNOMEUIINFO_SEPARATOR,

	GNOMEUIINFO_ITEM("Energy-level Diagram", "create a new energy-level diagram view.",
		popup_ViewsNewEnLevDiag, NULL),
		
	GNOMEUIINFO_END
};

GnomeUIInfo gnome_qm1_docv::views_submenu[] =
{
	GNOMEUIINFO_ITEM("Attach/Detach This View", "attach/detach this view...",
		gnome_graphics_view::popup_ViewsAttachDetach, NULL),
		
	GNOMEUIINFO_SEPARATOR,
	
	GNOMEUIINFO_SUBTREE("_Create", viewscreate_submenu),
	
	GNOMEUIINFO_ITEM("Delete This View", "remove this view...",
		gnome_graphics_view::popup_ViewsDeleteView, NULL),
		
	GNOMEUIINFO_END
};

GnomeUIInfo gnome_qm1_docv::lights_submenu[] =
{
	GNOMEUIINFO_ITEM("Create New Light", "create a new light object...",
		gnome_graphics_view::popup_LightsNewLight, NULL),
		
	GNOMEUIINFO_SEPARATOR,
	
	GNOMEUIINFO_ITEM("Switch Local Lights", "loc",
		gnome_graphics_view::popup_LightsSwitchLoc, NULL),
		
	GNOMEUIINFO_ITEM("Switch Global Lights", "glob",
		gnome_graphics_view::popup_LightsSwitchGlob, NULL),
		
	GNOMEUIINFO_END
};

GnomeUIInfo gnome_qm1_docv::rendermode_style_radio[] =
{
	GNOMEUIINFO_ITEM("Wireframe", "wf",
		popup_RModeWireFrame, NULL),
		
	GNOMEUIINFO_ITEM("Ball & Stick", "bs",
		popup_RModeBallAndStick, NULL),
		
	GNOMEUIINFO_ITEM("Nothing", "null",
		popup_RModeNothing, NULL),
		
	GNOMEUIINFO_END
};

GnomeUIInfo gnome_qm1_docv::rendermode_color_radio[] =
{
	GNOMEUIINFO_ITEM("Color Element", "color-el",
		popup_CModeElement, NULL),
		
	GNOMEUIINFO_END
};

GnomeUIInfo gnome_qm1_docv::rendermode_label_radio[] =
{
	GNOMEUIINFO_ITEM("Label Nothing", "lab-null",
		popup_LModeNothing, NULL),
		
//	GNOMEUIINFO_ITEM("Label DEBUG", "lab-???",
//		popup_LModeDEBUG, NULL),
	
	GNOMEUIINFO_END
};

GnomeUIInfo gnome_qm1_docv::rendermode_submenu[] =
{
        GNOMEUIINFO_RADIOLIST(rendermode_style_radio),
	GNOMEUIINFO_SEPARATOR,
        GNOMEUIINFO_RADIOLIST(rendermode_color_radio),
	GNOMEUIINFO_SEPARATOR,
        GNOMEUIINFO_RADIOLIST(rendermode_label_radio),
	GNOMEUIINFO_END
};

GnomeUIInfo gnome_qm1_docv::projection_submenu[] =
{
	GNOMEUIINFO_ITEM("Orthographic", "ortho",
		gnome_graphics_view::popup_ProjOrthographic, NULL),
		
	GNOMEUIINFO_ITEM("Perspective", "persp",
		gnome_graphics_view::popup_ProjPerspective, NULL),

	GNOMEUIINFO_ITEM("Red-Green Stereo", "redgre",
		gnome_graphics_view::popup_ProjRedGreen, NULL),
		
	GNOMEUIINFO_ITEM("Relaxed-Eye Stereo", "releye",
		gnome_graphics_view::popup_ProjRelaxedEye, NULL),
		
	GNOMEUIINFO_END
};

GnomeUIInfo gnome_qm1_docv::render_submenu[] =
{
	GNOMEUIINFO_SUBTREE("_Views", views_submenu),
	GNOMEUIINFO_SUBTREE("_Lights", lights_submenu),
	GNOMEUIINFO_SUBTREE("_Rendering Mode", rendermode_submenu),
	GNOMEUIINFO_SUBTREE("_Projection", projection_submenu),
	
	GNOMEUIINFO_ITEM("Quick Update Mode", "quick update...",
		gnome_graphics_view::popup_RenderQuickUpdate, NULL),
		
	GNOMEUIINFO_END
};

GnomeUIInfo gnome_qm1_docv::objects_submenu[] =
{
	GNOMEUIINFO_ITEM("ESP-plane", "...",
		popup_ObjEPlane, NULL),
		
	GNOMEUIINFO_ITEM("ESP-surface", "...",
		popup_ObjESurface, NULL),
		
	GNOMEUIINFO_ITEM("ESP-colored vdW-surface", "...",
		popup_ObjVDWSurface, NULL),
		
	GNOMEUIINFO_ITEM("Electron density plane", "...",
		popup_ObjEDPlane, NULL),
		
	GNOMEUIINFO_ITEM("Electron density surface", "...",
		popup_ObjEDSurface, NULL),
		
	GNOMEUIINFO_ITEM("Molecular orbital plane", "...",
		popup_ObjMOPlane, NULL),
		
	GNOMEUIINFO_ITEM("Molecular orbital volume", "...",
		popup_ObjMOVolume, NULL),
		
	GNOMEUIINFO_ITEM("Molecular orbital surface", "...",
		popup_ObjMOSurface, NULL),
		
	GNOMEUIINFO_ITEM("MO-density plane", "...",
		popup_ObjMODPlane, NULL),
		
	GNOMEUIINFO_ITEM("MO-density volume", "...",
		popup_ObjMODVolume, NULL),
		
	GNOMEUIINFO_ITEM("MO-density surface", "...",
		popup_ObjMODSurface, NULL),
		
	GNOMEUIINFO_SEPARATOR,
	
	GNOMEUIINFO_ITEM("Delete Current Object", "delete",
		gnome_graphics_view::popup_ObjectsDeleteCurrent, NULL),
		
	GNOMEUIINFO_END
};

GnomeUIInfo gnome_qm1_docv::compute_submenu[] =
{
	GNOMEUIINFO_ITEM("Setup...", "...",
		popup_CompSetup, NULL),
		
	GNOMEUIINFO_SEPARATOR,
	
	GNOMEUIINFO_ITEM("Energy", "...",
		popup_CompEnergy, NULL),
		
	GNOMEUIINFO_ITEM("Geometry Optimization...", "...",
		popup_CompGeomOpt, NULL),
		
	GNOMEUIINFO_END
};

GnomeUIInfo gnome_qm1_docv::popupmenu_info[] =
{
	// a "tearoff" item would be nice here at the beginning !?!?!?!??!?!?!?!?!?!?!?!!!!???!??!!!
	// a "tearoff" item would be nice here at the beginning !?!?!?!??!?!?!?!?!?!?!?!!!!???!??!!!
	// a "tearoff" item would be nice here at the beginning !?!?!?!??!?!?!?!?!?!?!?!!!!???!??!!!
	
	GNOMEUIINFO_SUBTREE("_File", file_submenu),
	GNOMEUIINFO_SUBTREE("_Select", select_submenu),
	
	GNOMEUIINFO_SEPARATOR,
	
	GNOMEUIINFO_SUBTREE("_Settings...", settings_submenu),
	
	GNOMEUIINFO_SEPARATOR,
	
	GNOMEUIINFO_SUBTREE("_Render", render_submenu),
	GNOMEUIINFO_SUBTREE("_Objects", objects_submenu),
	
	GNOMEUIINFO_SEPARATOR,
	
	GNOMEUIINFO_SUBTREE("_Compute", compute_submenu),
	
	GNOMEUIINFO_ITEM("Set Current Orbital", "...",
		popup_SetOrbital, NULL),
	
	GNOMEUIINFO_SEPARATOR,

	GNOMEUIINFO_ITEM("Enter a Command...", "Type in a command string and process it.",
		popup_EnterCommand, NULL),
	
	GNOMEUIINFO_ITEM("Convert to MM project", "Convert this project into a Molecular Mechanics project.",
		popup_ConvertMM, NULL),
	
	GNOMEUIINFO_END
};

/*################################################################################################*/

qm1_geomopt_param * gnome_qm1_docv::goparam = NULL;

gnome_qm1_docv::gnome_qm1_docv(ostream * p1, gnome_class_factory & p2) :
	gnome_docv(p1, p2), qm1_docv(p1, p2), docview(p1, p2), model_simple(p1, p2)
{
	popupmenu = gnome_popup_menu_new(popupmenu_info);
}

gnome_qm1_docv::~gnome_qm1_docv(void)
{
}

/*##############################################*/
/*##############################################*/

// the qm1-dependent popup-menu callbacks are here...
// the qm1-dependent popup-menu callbacks are here...
// the qm1-dependent popup-menu callbacks are here...

void gnome_qm1_docv::popup_FileOpen(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gnome_qm1_docv * docv = dynamic_cast<gnome_qm1_docv *>(gv->docv);
	
	if (docv) new qm1_file_open_dialog(docv);
}

void gnome_qm1_docv::popup_FileSaveAs(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gnome_qm1_docv * docv = dynamic_cast<gnome_qm1_docv *>(gv->docv);
	glade_modal_dialog_owner = docv;	// requires modal dialogs!!!
	
	if (docv) new qm1_file_save_dialog(docv);
}

void gnome_qm1_docv::popup_FileExtra1(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gnome_qm1_docv * docv = dynamic_cast<gnome_qm1_docv *>(gv->docv);
	
	// no operation...
}

void gnome_qm1_docv::popup_ViewsNewEnLevDiag(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gnome_qm1_docv * docv = dynamic_cast<gnome_qm1_docv *>(gv->docv);
	
	docv->AddEnLevDiagView();
}

void gnome_qm1_docv::popup_RModeWireFrame(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gv->render = RENDER_WIREFRAME; gv->docv->UpdateAllGraphicsViews();
}

void gnome_qm1_docv::popup_RModeBallAndStick(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gv->render = RENDER_BALL_AND_STICK; gv->docv->UpdateAllGraphicsViews();
}

void gnome_qm1_docv::popup_RModeNothing(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gv->render = RENDER_NOTHING; gv->docv->UpdateAllGraphicsViews();
}

void gnome_qm1_docv::popup_LModeNothing(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gv->label = LABEL_NOTHING; gv->docv->UpdateAllGraphicsViews();
}

void gnome_qm1_docv::popup_LModeDEBUG(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gv->label = LABEL_CHARGE; gv->docv->UpdateAllGraphicsViews();			// DEBUG!!!
}

void gnome_qm1_docv::popup_CModeElement(GtkWidget *, gpointer data)
{
// color modes not yet implemented at all here...
//	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
//	gv->colormode = & mm2_docv::cm_element; gv->docv->UpdateAllGraphicsViews();
}

void gnome_qm1_docv::popup_ObjEPlane(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gnome_qm1_docv * docv = dynamic_cast<gnome_qm1_docv *>(gv->docv);
	if (docv)
	{
if (!docv->current_eng) { docv->err->ErrorMessage("Calculate energy first!!!"); return; }
		
		static const char command[] = "add plane esp rb1 138.0 0.75 50 1 0.75";
		new command_dialog(docv, gv, command);
	}
}

void gnome_qm1_docv::popup_ObjESurface(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gnome_qm1_docv * docv = dynamic_cast<gnome_qm1_docv *>(gv->docv);
	if (docv)
	{
if (!docv->current_eng) { docv->err->ErrorMessage("Calculate energy first!!!"); return; }
		
		static const char command[] = "add surf2 esp unity red blue +35.0 -35.0 1.0 1.5 50 0 0 0.50";
		new command_dialog(docv, gv, command);
	}
}

void gnome_qm1_docv::popup_ObjVDWSurface(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gnome_qm1_docv * docv = dynamic_cast<gnome_qm1_docv *>(gv->docv);
	if (docv)
	{
if (!docv->current_eng) { docv->err->ErrorMessage("Calculate energy first!!!"); return; }
		
		static const char command[] = "add surf1 vdws esp rb1 1.0 70.0 1.5 50 1 1 0.65";
		new command_dialog(docv, gv, command);
	}
}

void gnome_qm1_docv::popup_ObjEDPlane(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gnome_qm1_docv * docv = dynamic_cast<gnome_qm1_docv *>(gv->docv);
	if (docv)
	{
if (!docv->current_eng) { docv->err->ErrorMessage("Calculate energy first!!!"); return; }
		
		static const char command[] = "add plane eldens rb1 0.05 0.75 50 1 0.75";
		new command_dialog(docv, gv, command);
	}
}

void gnome_qm1_docv::popup_ObjEDSurface(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gnome_qm1_docv * docv = dynamic_cast<gnome_qm1_docv *>(gv->docv);
	if (docv)
	{
if (!docv->current_eng) { docv->err->ErrorMessage("Calculate energy first!!!"); return; }
		
		static const char command[] = "add surf1 eldens unity red 0.01 1.0 1.5 50 0 0 0.65";
		new command_dialog(docv, gv, command);
	}
}

void gnome_qm1_docv::popup_ObjMOPlane(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gnome_qm1_docv * docv = dynamic_cast<gnome_qm1_docv *>(gv->docv);
	if (docv)
	{
if (!docv->current_eng) { docv->err->ErrorMessage("Calculate energy first!!!"); return; }
		
		static const char command[] = "add plane mo rb1 0.05 0.75 50 1 0.75";
		new command_dialog(docv, gv, command);
	}
}

void gnome_qm1_docv::popup_ObjMOVolume(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gnome_qm1_docv * docv = dynamic_cast<gnome_qm1_docv *>(gv->docv);
	if (docv)
	{
if (!docv->current_eng) { docv->err->ErrorMessage("Calculate energy first!!!"); return; }
		
		static const char command[] = "add volrend mo rb2 0.025 1.5 25 0.50";
		new command_dialog(docv, gv, command);
	}
}

void gnome_qm1_docv::popup_ObjMOSurface(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gnome_qm1_docv * docv = dynamic_cast<gnome_qm1_docv *>(gv->docv);
	if (docv)
	{
if (!docv->current_eng) { docv->err->ErrorMessage("Calculate energy first!!!"); return; }
		
		static const char command[] = "add surf2 mo unity red blue +0.025 -0.025 1.0 1.5 50 0 0 0.50";
		new command_dialog(docv, gv, command);
	}
}

void gnome_qm1_docv::popup_ObjMODPlane(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gnome_qm1_docv * docv = dynamic_cast<gnome_qm1_docv *>(gv->docv);
	if (docv)
	{
if (!docv->current_eng) { docv->err->ErrorMessage("Calculate energy first!!!"); return; }
		
		static const char command[] = "add plane mod rb1 0.005 0.75 50 1 0.75";
		new command_dialog(docv, gv, command);
	}
}

void gnome_qm1_docv::popup_ObjMODVolume(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gnome_qm1_docv * docv = dynamic_cast<gnome_qm1_docv *>(gv->docv);
	if (docv)
	{
if (!docv->current_eng) { docv->err->ErrorMessage("Calculate energy first!!!"); return; }
		
		static const char command[] = "add volrend mod rb2 0.0025 1.5 25 0.35";
		new command_dialog(docv, gv, command);
	}
}

void gnome_qm1_docv::popup_ObjMODSurface(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gnome_qm1_docv * docv = dynamic_cast<gnome_qm1_docv *>(gv->docv);
	if (docv)
	{
if (!docv->current_eng) { docv->err->ErrorMessage("Calculate energy first!!!"); return; }
		
		static const char command[] = "add surf1 mod unity red 0.0025 1.0 1.5 50 0 0 0.65";
		new command_dialog(docv, gv, command);
	}
}

void gnome_qm1_docv::popup_CompSetup(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gnome_qm1_docv * docv = dynamic_cast<gnome_qm1_docv *>(gv->docv);
	glade_modal_dialog_owner = docv;	// requires modal dialogs!!!
	
	new setup_qm1_dialog();
	//GtkWidget * dialog = create_e1_dialog_qm1_setup();	// obsolete
	//gtk_widget_show(dialog);				// obsolete
}

void gnome_qm1_docv::popup_CompEnergy(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gnome_qm1_docv * docv = dynamic_cast<gnome_qm1_docv *>(gv->docv);
	if (docv) docv->DoEnergy();
}

void gnome_qm1_docv::popup_CompGeomOpt(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gnome_qm1_docv * docv = dynamic_cast<gnome_qm1_docv *>(gv->docv);
	if (docv)
	{
		qm1_geomopt_param param;
		param.treshold_nsteps = 100;
		param.treshold_grad = 1.0e-3;
		param.treshold_delta_e = 1.0e-7;

		docv->DoGeomOpt(param);
	}
}

void gnome_qm1_docv::popup_SetOrbital(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gnome_qm1_docv * docv = dynamic_cast<gnome_qm1_docv *>(gv->docv);
	if (docv)
	{
		docv->err->Message("PLEASE NOTE!\nThe command string, which is displayed in the next dialog, is incomplete.\nYou should replace the letter X with the orbital index that will become the current orbital.");
		
		static const char command[] = "set_current_orbital X";
		new command_dialog(gv->docv, gv, command);
	}
}

void gnome_qm1_docv::popup_EnterCommand(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gnome_qm1_docv * docv = dynamic_cast<gnome_qm1_docv *>(gv->docv);
	if (docv)
	{
		new command_dialog(docv, gv, NULL);
	}
}

void gnome_qm1_docv::popup_ConvertMM(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gnome_qm1_docv * docv = dynamic_cast<gnome_qm1_docv *>(gv->docv);
	if (docv)
	{
		const char message[] = "Should I close this old project?";
		bool close_old = docv->err->Question(message);
		
		gnome_mm1_docv * mm_docv;
		mm_docv = new gnome_mm1_docv(& cout, * gnome_class_factory::GetInstance());
	// keep the same project name only if old was closed??? might be confusing otherwise???
	if (close_old) mm_docv->SetProjectFileName(docv->GetProjectFileName(false));
		mm_docv->InitGnomeMDIChild();
		
// when calling InitGnomeMDIChild(), also a graphics_view and therefore a new camera object were added.
// is order to retain as much grahics settings as possible, copy the current view's camera settings to
// the new project's view. WARNING!!! this is a bit ugly way to do it: in the new project, there is
// only a single view object and a single camera object; so we just pick them! TODO : lights???
mm_docv->camera_vector.front()->CopySettings(gv->cam);
// an initial solution to the lights problem : remove the old light and make a new one using default
// settings. looks good if the user has not modified the lights, but otherwise restores defaults.
mm_docv->RemoveLight(mm_docv->light_vector.front());
mm_docv->AddLocalLight(new directional_light(ol_static(mm_docv->camera_vector.front()->GetLocData())), mm_docv->camera_vector.front());

		// convert qm1mdl -> mm1mdl using all_atoms_interface...
		
		mm_docv->aai_MakeCopy(docv);
		
		// ...the conversion is now ready.
		
		if (close_old) gnome_mdi_remove_child(gnome_mdi_app::mdi, GNOME_MDI_CHILD(gv->docv->child), TRUE);
	}
}

/*##############################################*/
/*##############################################*/

void gnome_qm1_docv::GeomOptGetParam(qm1_geomopt_param & param)
{
	glade_modal_dialog_owner = this;	// requires modal dialogs!!!
	
	// here we just set "param" to a static variable,
	// where it's then available in glade code...
	
	goparam = & param;
	
	new geomopt_dialog();	// the object will call delete itself...
	//GtkWidget * dialog = create_a1_dialog_geomopt();	// obsolete
	//gnome_dialog_run_and_close(GNOME_DIALOG(dialog));	// obsolete
	
	goparam = NULL;
}

/*################################################################################################*/

// eof
