// MATRIX.H : some matrix utilities here...

// Copyright (C) 1998 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "config.h"	// this is target-dependent...

#ifndef MATRIX_H
#define MATRIX_H

/*################################################################################################*/

#include "typedef.h"

/*################################################################################################*/

template <class TYPE1> class gauss_elimination
{
	private:
	
	// the index for matrix element ij = (i*size + j), where row = i and column = j
	// the index for matrix element ij = (i*size + j), where row = i and column = j
	// the index for matrix element ij = (i*size + j), where row = i and column = j
	
	i32s index(i32s row, i32s col)
	{
		return row * size + col;
	}
	
	i32s size;
	TYPE1 * m1;
	TYPE1 * v1;
	TYPE1 * v2;
	
	public:
	
	gauss_elimination(i32s p1, TYPE1 * p2, TYPE1 * p3)
	{
		size = p1;
		m1 = p2; v2 = p3;
		v1 = new TYPE1[size];
	}
	
	~gauss_elimination(void)
	{
		delete[] v1;
	}
	
	void solve(void)	// partial pivoting might be quite easy to add here...
	{
		for (i32s n1 = 0;n1 < size - 1;n1++)
		{
			for (i32s n2 = n1 + 1;n2 < size;n2++)
			{
				TYPE1 tmp = m1[index(n2, n1)] / m1[index(n1, n1)];
				v2[n2] -= tmp * v2[n1];
				
				for (i32s n3 = 0;n3 < size;n3++)
				{
					m1[index(n2, n3)] -= tmp * m1[index(n1, n3)];
				}
			}
		}
		
		for (i32s n1 = size - 1;n1 > -1;n1--)
		{
			TYPE1 sum = 0.0;
			for (i32s n2 = size - 1;n2 > n1;n2--)
			{
				sum += m1[index(n1, n2)] * v1[n2];
			}
			
			v1[n1] = (v2[n1] - sum) / m1[index(n1, n1)];
		}
	}
	
	TYPE1 getvalue(i32s p1)
	{
		return v1[p1];
	}
};

/*################################################################################################*/

#endif	// MATRIX_H

// eof
