with Iirs; use Iirs;

package Sem_Decls is
   --  The kind of an inteface list.
   type Interface_Kind_Type is (Interface_Generic, Interface_Port,
                                Interface_Procedure, Interface_Function);
   subtype Parameter_Kind_Subtype is
     Interface_Kind_Type range Interface_Procedure .. Interface_Function;

   procedure Sem_Interface_Chain (Interface_Chain: Iir;
                                  Interface_Kind : Interface_Kind_Type);

   --  Create predefined operations for DECL.
   procedure Create_Implicit_Operations
     (Decl : Iir; Is_Std_Standard : Boolean := False);

   --  Semantize declarations of PARENT.
   procedure Sem_Declaration_Chain (Parent : Iir);

   --  Check all declarations of DECLS_PARENT are complete
   --  This checks subprograms, deferred constants, incomplete types and
   --  protected types.
   --
   --  DECL is the declaration that contains the declaration_list DECLS_PARENT.
   --  (location of errors).
   --  DECL is different from DECLS_PARENT for package bodies and protected
   --  type bodies.
   --
   --  Also, report unused declarations if DECL = DECLS_PARENT.
   --  As a consequence, Check_Full_Declaration must be called after sem
   --  of statements, if any.
   procedure Check_Full_Declaration (Decls_Parent : Iir; Decl: Iir);

   procedure Sem_Iterator (Iterator : Iir_Iterator_Declaration;
                           Staticness : Iir_Staticness);

   --  Extract from NAME the named entity whose profile matches SIG.
   function Sem_Signature (Name : Iir; Sig : Iir_Signature) return Iir;

end Sem_Decls;
