/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2003-2004 The GFC Development Team.
 *
 *  marshal.hh - Private interface
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef GFC_ATK_MARSHALL_HH
#define GFC_ATK_MARSHALL_HH

#ifndef GFC_G_MARSHALL_HH
#include <gfc/glib/private/marshal.hh>
#endif

#ifndef __ATK_H__
#include <atk/atkobject.h>
#endif

namespace GFC {

namespace Atk {

// Atk::Marshal provides the signal callback functions used by ATK Objects
// to translate GObject signal notifications into sigc::slot calls.

class Marshal
{
public:
	static void void_int_pvoid_callback(void*, unsigned int, void*);

	static void void_patkpropertyvalues_callback(void*, AtkPropertyValues*);

	static void void_string_bool_callback(void*, const char*, bool);

	static void void_ppvoid_callback(void*, void**);
};

} // namespace Atk

} // namespace GFC

#endif // GFC_ATK_MARSHALL_HH

