/*  GFC-Core: GTK+ Foundation Classes (Core Library)
 *  Copyright (C) 2004 The GFC Development Team.
 *
 *  objectsignals.cc - G::Object virtual signal handlers
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "object.hh"
#include "objectsignals.hh"
#include "quark.hh"
#include "private/objectclass.hh"
#include <glib/gmessages.h>

using namespace GFC;

/*  G::ObjectSignals
 */

G::ObjectSignals::ObjectSignals(Object *object)
{
	if (object)	
		object->set_data(quark(), this);
	else
		g_error("Invalid pointer: you passed a null pointer to a G::ObjectSignals class constructor.");
		
	G::ObjectClass::init(G_OBJECT_GET_CLASS(object->g_object()));
}

G::ObjectSignals::~ObjectSignals()
{
}

void
G::ObjectSignals::on_notify(GParamSpec *pspec)
{
	GObjectClass *g_class = ObjectClass::get_parent_class(instance_);
	if (g_class->notify)
		g_class->notify((GObject*)instance_, pspec);
}

GQuark
G::ObjectSignals::quark()
{
	static GQuark quark_ = 0;
	if (!quark_)
	{
		quark_ = g_quark_from_static_string("gfc_object_signals");
	}
	return quark_;
}

/*  G::ObjectClass
 */

void
G::ObjectClass::init(GObjectClass *g_class)
{
	g_class->notify = &notify_proxy;
}

GObjectClass*
G::ObjectClass::get_parent_class(void *instance)
{
	void *ptr = g_type_class_peek_parent(G_OBJECT_GET_CLASS(instance));
	return static_cast<GObjectClass*>(ptr);
}

GType
G::ObjectClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(G_TYPE_OBJECT);
	}
	return type;
}

GQuark
G::ObjectClass::quark()
{
	static GQuark quark_ = 0;
	if (!quark_)
	{
		quark_ = g_quark_from_static_string("gfc_object");
	}
	return quark_;
}

void*
G::ObjectClass::create()
{
	return g_object_new(get_type(), 0);
}

void
G::ObjectClass::notify_proxy(GObject *object, GParamSpec *pspec)
{
	void *ptr = g_object_get_qdata(object, ObjectSignals::quark());
	if (ptr)
		static_cast<ObjectSignals*>(ptr)->on_notify(pspec);
	else
	{
		GObjectClass *g_class = ObjectClass::get_parent_class(object);
		if (g_class->notify)
			g_class->notify(object, pspec);
	}
}

