/*  GFC-Core: GTK+ Foundation Classes (Core Library)
 *  Copyright (C) 2004 The GFC Development Team.
 *
 *  gfccore.cc - Main GFC-Core source file
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "gfccore.hh"

/*  GFC-Core major, minor and micro version numbers
 */

extern const unsigned int gfc_core_major_version = GFC_CORE_MAJOR_VERSION;
extern const unsigned int gfc_core_minor_version = GFC_CORE_MINOR_VERSION;
extern const unsigned int gfc_core_micro_version = GFC_CORE_MICRO_VERSION;

/*  gfc_core_check_version
 */

bool gfc_core_check_version(int major, int minor, int micro)
{
	return (GFC_CORE_MAJOR_VERSION > major ||
	       (GFC_CORE_MAJOR_VERSION == major && GFC_CORE_MINOR_VERSION > minor) ||
	       (GFC_CORE_MAJOR_VERSION == major && GFC_CORE_MINOR_VERSION == minor && GFC_CORE_MICRO_VERSION >= micro));
}

