/*  $Id: lines.cpp,v 1.4 2002/04/03 06:11:28 sarrazip Exp $
    lines.cc - Small example for the gengameng library.

    lines - Small example for the gengameng library.
    Copyright (C) 2001 Pierre Sarrazin <http://sarrazip.com/>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
    02111-1307, USA.
*/

#include <gengameng/GameEngine.h>


class LinesEngine : public GameEngine
{
public:

    enum { WINDOW_WIDTH = 400, WINDOW_HEIGHT = 300 };

    LinesEngine(const string &windowManagerCaption);

    virtual ~LinesEngine();

    virtual void processKey(SDLKey keysym, bool pressed);
    /*  Inherited.
    */

    virtual bool tick();
    /*  Inherited.
    */

private:

    unsigned long tickCount;
    Uint32 blackColor;
    Uint32 greenColor;
    bool stopRequest;

};


/*virtual*/
LinesEngine::~LinesEngine()
{
}


LinesEngine::LinesEngine(const string &windowManagerCaption)
  : GameEngine(Couple(WINDOW_WIDTH, WINDOW_HEIGHT),
			windowManagerCaption,
			false /* not full screen */ ),
    tickCount(0),
    blackColor(SDL_MapRGB(theSDLScreen->format, 0, 0, 0)),
    greenColor(SDL_MapRGB(theSDLScreen->format, 0, 255, 0)),
    stopRequest(false)
{
}


/*virtual*/ void
LinesEngine::processKey(SDLKey keysym, bool pressed)
{
    if (keysym == SDLK_ESCAPE && pressed)
	stopRequest = true;
}


/*virtual*/ bool
LinesEngine::tick()
/*  This method is called every 50 milliseconds approximately.
    It must return false to indicate that the game engine must stop,
    or true to ask for it to continue calling this method.
*/
{
    if (stopRequest)
	return false;

    tickCount++;

    int b = tickCount / 20 & 1;  // switch between 0 and 1 every second
    int y0 = WINDOW_HEIGHT * (1 + b) / 3;
    int y1 = WINDOW_HEIGHT * (2 - b) / 3;

    SDL_Rect rect0 = { 0, y0 - 5, WINDOW_WIDTH, 10 };
    (void) SDL_FillRect(theSDLScreen, &rect0, greenColor);
    SDL_Rect rect1 = { 0, y1 - 5, WINDOW_WIDTH, 10 };
    (void) SDL_FillRect(theSDLScreen, &rect1, blackColor);
	    // theSDLScreen is inherited from class GameEngine

    return true;
}


int main(int argc, char *argv[])
{
    try
    {
	LinesEngine theLinesEngine("Lines");
	theLinesEngine.run(55);
    }
    catch (const string &s)
    {
	fprintf(stderr, "Engine init error: %s\n", s.c_str());
	return EXIT_FAILURE;
    }
    catch (int e)
    {
	fprintf(stderr, "init error # %d\n", e);
	return EXIT_FAILURE;
    }

    return EXIT_SUCCESS;
}
