/* colors.c
 * geg, a GTK+ Equation Grapher
 * David Bryant 1998
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /* HAVE_CONFIG_H */

#include "colors.h"

/* global data */
misc_colors m_colors = 
{ NULL, 
  NULL, 
  NULL,
  NULL };

/* locally global data */
static GdkColor *f_colors[] =
{ NULL, 
  NULL, 
  NULL, 
  NULL, 
  NULL, 
  NULL, 
  NULL, 
  NULL };

/* locally globale data */
static gdouble f_values[][3] =  /* saturation of 0.5, hue steps of 45 */
{ {1.00, 0.50, 0.50},
  {1.00, 0.88, 0.50},
  {0.75, 1.00, 0.50},
  {0.50, 1.00, 0.62},
  {0.50, 1.00, 1.00},
  {0.50, 0.62, 1.00},
  {0.75, 0.50, 1.00},
  {1.00, 0.50, 0.88} };

static guint n_f_colors = sizeof(f_colors) / sizeof(f_colors[0]);

/* alloc_color, convenience function to allocate a color from vals
 */
void
alloc_color(GdkColor **color, gdouble *vals, GdkColormap *colormap)
{
  if(!*color)
    *color = g_new(GdkColor, 1);
  (*color)->red   = (gushort)(65535 * vals[0]);
  (*color)->green = (gushort)(65535 * vals[1]);
  (*color)->blue  = (gushort)(65535 * vals[2]);

  g_assert(colormap != NULL);
  g_assert(gdk_color_alloc(colormap, *color) != 0);
}

/* function_color, gives caller the color that should be used to draw function
 * number
 */
GdkColor *function_color(gint number) {
  return(f_colors[number % (n_f_colors - 1)]);
}

/* alloc_func_colors, allocates the colors to be used for the functions
 */
void alloc_func_colors(GdkColormap *colormap)
{
  int i;

  for(i = 0; i < n_f_colors; i++)
    alloc_color(&f_colors[i], f_values[i], colormap); 
}
