/*
  GNOME Comics Organizer
  Copyright (C) 1999-2000 Maxximum Software
   
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <glib.h>
#include <gnome.h>
#include <glade/glade.h>
#include "comiclist.h"
#include "functions.h"
#include "preferences_window.h"
#include "debug.h"

#if USE_GNOME_VFS
#include <libgnomevfs/gnome-vfs.h>
#endif

GladeXML *xml;
GString *GLADE_FILE;
GString *welcome_msg = NULL;

GList *ComicList = NULL;

gchar *new_filename = NULL;
gchar *current_filename = NULL;
gboolean file_changed = FALSE;

GCompareFunc TComicCompare = CompareTComic_Title;

const gchar *MainWindowKey = "MainWindowKey";
const gchar *ComicListKey = "ComicListKey";
const gchar *ComicToAddKey = "ComicToAddKey";
const gchar *ComicToAddToKey = "ComicToAddToKey";
const gchar *ComicToEditKey = "ComicToEditKey";
const gchar *IssueToEditKey = "IssueToEditKey";

GList *publisher_history = NULL;
GList *type_history = NULL;
GList *group_history = NULL;

GList *cover_price_history = NULL; /* currently not used */
GList *current_price_history = NULL; /* currently not used */
GList *purchase_price_history = NULL; /* currently not used */

GList *location_history = NULL;

GList *writer_history = NULL;
GList *penciler_history = NULL;
GList *inker_history = NULL;

/* preferences - START */
gboolean auto_fill_issue = FALSE;

gboolean show_number_title = TRUE;
gboolean show_location_title = FALSE;
gboolean show_condition_title = FALSE;
gboolean show_cover_price_title = FALSE;
gboolean show_current_price_title = FALSE;
gboolean show_purchase_price_title = FALSE;
/* preferences - END */

int main (int argc, char *argv[])
{
  GtkWidget *main_window, *issues_clist, *menuitem;
  FILE *fp;

  bindtextdomain (PACKAGE, PACKAGE_LOCALE_DIR);
  textdomain (PACKAGE);

  GLADE_FILE = g_string_new (NULL);
  g_string_sprintf (GLADE_FILE, "%s/%s", GCO_GLADEDIR, "gco.glade");

  gnome_init ("gco", VERSION, argc, argv);
  glade_gnome_init();

#if USE_GNOME_VFS
  if (! gnome_vfs_init ()) {
    g_warning ("Cannot initialize gnome-vfs.\n");
    return 1;
  }
#endif

  fp = fopen (GLADE_FILE->str, "r");
  if (fp == NULL)
    {
      /* The glade file wasn't found - try in .. (for ease of development/testing only) */

      dprintf ("%s not found - trying in ..\n", GLADE_FILE->str);
      
      g_string_sprintf (GLADE_FILE, "%s/%s", "..", "gco.glade");
    }

  xml = glade_xml_new (GLADE_FILE->str, "main_window");
  if (!xml)
    {
      g_warning ("Unable to load the interface.");
      return 1;
    }

  glade_xml_signal_autoconnect (xml);
  main_window = glade_xml_get_widget (xml, "main_window");

  load_prefs_and_history ();

  /* Disable unused menuitems */
  menuitem = glade_xml_get_widget (xml, "mainmenu_edit_add_sequence_of_issues");
  gtk_widget_set_sensitive (menuitem, FALSE);
  menuitem = glade_xml_get_widget (xml, "mainmenu_edit_add_file_link");
  gtk_widget_set_sensitive (menuitem, FALSE);

  gtk_window_set_title (GTK_WINDOW (main_window), "GNOME Comics Organizer - Untitled");
  gtk_widget_show (main_window);

  issues_clist = glade_xml_get_widget (xml, "issues_clist");
  gtk_clist_column_titles_passive (GTK_CLIST(issues_clist));

  gtk_clist_set_columns (GTK_CLIST(issues_clist));

  welcome_msg = g_string_new ("Welcome to GNOME Comics Organizer");
  gnome_app_flash (GNOME_APP (main_window), welcome_msg->str);

  gtk_main ();

  /* Control returns here when gtk_main_quit() is called, but not when
   * gtk_exit is used. */

  save_prefs_and_history ();

  return 0;
}
