/*
 * fileaccess.h
 * Thomas Nemeth, le 25.09.1999
 *
 * HEADER
 * Accs aux fichiers de config de gAcc, gestionnaire de comptes
 * banquaires personnels avec GTK+.
 *
 *   Copyright (C) 1999  Thomas Nemeth
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef _FILEACCESS_H_
#define _FILEACCESS_H_

#include <config.h>
#include <stdio.h>
#include <stdlib.h>


/* Rcupre une chaine de caractre dans la chaine en paramtre       */
/* Get a string in the string in parameter                            */
void get_string_from_line (char **var, char *line);

/* Rcupre un entier de caractre dans la chaine en paramtre        */
/* Get an integer in the string in parameter                          */
void get_int_from_line (int *var, char *line);

/* Rcupre un rel de caractre dans la chaine en paramtre          */
/* Get a float in the string in parameter                             */
void get_float_from_line (float *var, char *line);

/* Rcupre un caractre de caractre dans la chaine en paramtre     */
/* Get a char in the string in parameter                              */
void get_char_from_line (char *var, char *line);

/* Rcupre une chaine de caractre dans le fichier en paramtre      */
/* Get a string in the file in parameter                              */
char *get_string_from_file (FILE *f);

/* Rcupre un rel dans le fichier                                   */
/* Get a real in the file                                             */
float get_float_from_file (FILE *f);

/* Rcupre un entier dans le fichier                                 */
/* Get an integer in the file                                         */
int get_int_from_file (FILE *f);

/* Rcupre un caractre dans le fichier                              */
/* Get a character in the file                                        */
char get_char_from_file (FILE *f);

/* Ouvre un fichier et renvoie le numro de version                   */
/* Open a file and return its version number                          */
char *open_file (char *filename, FILE **file);

/* cris l'entte d'un fichier de config avec une description         */
/* Write a config file's header with description                      */
void create_file_header (FILE *file, char *description);

/* Renvoie VRAI si version est comprise entre les 2 spcifies        */
/* Return VRAI if version is between the 2 speficied                  */
int in_versions (const char *first_version, const char *last_version,
                 const char *version);

#endif
