/*
 * fileaccess.c
 * Thomas Nemeth, le 25.09.1999
 *
 * Accs aux fichiers de config de gAcc, gestionnaire de comptes
 * banquaires personnels avec GTK+.
 *
 *   Copyright (C) 1999  Thomas Nemeth
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <config.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "fileaccess.h"
#include "structs.h"
#include "usefull.h"


void get_string_from_line (char **var, char *line) {
    char *result = NULL;
    char  tmpresult [MAXSTRLEN + 1];
    int   i, j;

    j = 0;
    for (i = KEYLENGTH ; i < strlen (line) ; i++)
        if (line [i] != '\n') {
            tmpresult [j] = line [i];
            j++;
        }
    tmpresult [j] = 0;
    if (strlen (tmpresult) > 0) {
        MY_ALLOC (result, (strlen (tmpresult) + 1), char);
        strcpy (result, tmpresult);
        if (*var != NULL) free (*var);
        *var = result;
        #ifdef DEBUG_GACC
            printf ("Valeur retourne : %s\n", *var);
        #endif
    }
}

void get_int_from_line (int *var, char *line) {
    int  result = 0;
    char unusedstr [KEYLENGTH + 2];

    sscanf (line, "%s %d", unusedstr, &result);
    *var = result;
}

void get_float_from_line (float *var, char *line) {
    float result = 0.0;
    char  unusedstr [KEYLENGTH + 2];

    sscanf (line, "%s %f", unusedstr, &result);
    *var = result;
}

void get_char_from_line (char *var, char *line) {
    char result = 0;
    char unusedstr [KEYLENGTH + 2];

    sscanf (line, "%s %c", unusedstr, &result);
    *var = result;
}

char *get_string_from_file (FILE *f) {
    char *result = NULL;
    char  tmpstr [MAXSTRLEN + 1];
    char  tmpresult [MAXSTRLEN + 1];
    int   i, j;

    fgets (tmpstr, (int) MAXSTRLEN, f);
    j = 0;
    for (i = KEYLENGTH ; i < strlen (tmpstr) ; i++)
        if (tmpstr [i] != '\n') {
            tmpresult [j] = tmpstr [i];
            j++;
        }
    tmpresult [j] = 0;
    if (strlen (tmpresult) > 0) {
        MY_ALLOC (result, (strlen (tmpresult) + 1), char);
        strcpy (result, tmpresult);
    }
    return result;
}

float get_float_from_file (FILE *f) {
    float result = 0.0;
    char  tmpstr [MAXSTRLEN + 1], unusedstr [10];

    fgets (tmpstr, (int) MAXSTRLEN, f);
    sscanf (tmpstr, "%s %f", unusedstr, &result);
    return result;
}

int get_int_from_file (FILE *f) {
    int  result = 0;
    char tmpstr [MAXSTRLEN + 1], unusedstr [10];

    fgets (tmpstr, (int) MAXSTRLEN, f);
    sscanf (tmpstr, "%s %d", unusedstr, &result);
    return result;
}

char get_char_from_file (FILE *f) {
    char result = 0;
    char tmpstr [MAXSTRLEN + 1], unusedstr [10];

    fgets (tmpstr, (int) MAXSTRLEN, f);
    sscanf (tmpstr, "%s %c", unusedstr, &result);
    return result;
}

char *open_file (char *filename, FILE **file) {
    char  tmpstr [MAXSTRLEN + 1];
    char  FileName [MAXSTRLEN + 1];
    char  * FileVersion = NULL;
    int   i;

    #ifdef DEBUG_GACC
		printf ("Ouverture du fichier : %s\n", filename);
    #endif	

	MY_ALLOC (FileVersion, MAXVERSIONSIZE, char);
	strcpy (FileVersion, "");
		
    if ( (*file = fopen (filename, "r") ) == NULL) {
        printf ("Cannot open %s.\n",filename);
    } else {
        fgets (tmpstr, (int) MAXSTRLEN, *file);
        if (sscanf (tmpstr, "gAcc version %s", FileVersion) ) {
			for (i = 0 ; i < HEADLINES - 1 ; i++)
				fgets (tmpstr, (int) MAXSTRLEN, *file);
		} else {
			if (sscanf (tmpstr, "# CBB Data File -- %s", FileName) ) {
				strcpy (FileVersion,"CBB");
			}
		}
    }
    
	#ifdef DEBUG_GACC
		printf ("Version du fichier : %s\n", FileVersion);
		printf ("Version par dfaut : %s\n", VERSION);
		if (strcmp (FileVersion, VERSION) == 0) printf ("Elles sont gales\n");
		else printf ("Elles sont diffrentes !\n");
	#endif
    return FileVersion;
}

void create_file_header (FILE *file, char *description) {
    fprintf (file, "gAcc version %s\n", VERSION);
    fprintf (file, "%s\n\n", description);
    fprintf (file, "KEYWORDS ARE ONLY THERE TO INDENTIFY THE INFORMATIONS\n");
    fprintf (file, "DO NOT ATTEMPT TO MODIFY THEIR ORDER !\n");
    fprintf (file, "-----------------------------------------------------\n");
}

int in_versions (const char *first_version, const char *last_version,
                 const char *version) {
    int ret;
    #ifdef DEBUG_GACC
        printf ("Est-ce que la version du fichier ouvert (%s) est dans ",
                version);
        printf ("[%s, %s] ?\n", first_version, last_version);
        printf ("%s %c %s", first_version,
                (strcmp (first_version, version) > 0) ? '>' :
                (strcmp (first_version, version) == 0) ? '=' : '<',
                version);
        printf ("  ET  %s %c %s", version,
                (strcmp (version, last_version) > 0) ? '>' :
                (strcmp (version, last_version) == 0) ? '=' : '<',
                last_version);
    #endif
    if ( (strcmp (first_version, version) <= 0) &&
         (strcmp (version, last_version)  <= 0) )
        ret = VRAI;
    else ret = FAUX;

    #ifdef DEBUG_GACC
        if (ret == VRAI) {
            printf (" donc %s EST dans l'intervalle ", version);
            printf ("[%s, %s]\n", first_version, last_version);
        } else {
            printf (" donc %s N'est PAS dans l'intervalle ", version);
            printf ("[%s, %s]\n", first_version, last_version);
        }
    #endif
    return ret;
}
