/*
 * acclists.c
 * Thomas Nemeth, le 18.09.1999
 *
 * Gestion de la liste des donnes de gAcc, gestionnaire de comptes
 * banquaires personnels avec GTK+.
 *
 *   Copyright (C) 1999  Thomas Nemeth
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <config.h>
#include <stdio.h>
#include <stdlib.h>
#include "structs.h"
#include "acclists.h"


/* ------++++++======****** AIDE ******* HELP ******======++++++----- */

void help_push (const char *index) {
    HELP *help = config.help_history;

    if (help != NULL) {
        while (help->next != NULL) help = help->next;
        MY_ALLOC (help->next, 1, HELP);
        help = help->next;
    } else {
        MY_ALLOC (config.help_history, 1, HELP);
        help = config.help_history;
    }
    MY_ALLOC (help->index, strlen (index) + 1, char);
    #ifdef DEBUG_GACC
        printf ("Ajout de l'index d'aide : %s\n", index);
    #endif
    strcpy (help->index, index);
    help->next = NULL;
}

void help_pop () {
     HELP *help = config.help_history;
     HELP *prev = NULL;

    if (help != NULL) {
        while (help->next != NULL) {
            prev = help;
            help = help->next;
        }
        #ifdef DEBUG_GACC
            printf ("Supression de l'index d'aide : %s\n", help->index);
        #endif
        free (help->index);
        free (help);
        if (prev != NULL)
            prev->next = NULL;
        else if (prev == NULL)
            config.help_history = NULL;
    }
}

char *help_top () {
     HELP *help = config.help_history;
     char *index;

    if (help != NULL) {
        while (help->next != NULL) help = help->next;
        index = help->index;
    } else {
        index = _("Help Index");
    }
    #ifdef DEBUG_GACC
        printf ("Renvoi de l'index d'aide : %s\n", index);
    #endif
    return index;
}

void help_empty () {
    HELP *help;

    while (config.help_history != NULL) {
        help = config.help_history->next;
        free (config.help_history->index);
        free (config.help_history);
        config.help_history = help;
    }
}


/* ------++++++======****** LISTE *** MY_LIST ******======++++++----- */

MY_LIST *my_list_add (MY_LIST *list, void *element) {
    MY_LIST *l = list;

    if (list != NULL) {
        while (l->next != NULL) l = l->next;
        MY_ALLOC (l->next, 1, MY_LIST);
        l = l->next;
        l->element = element;
        l->next    = NULL;
    } else {
        MY_ALLOC (l, 1, MY_LIST);
        l->element = element;
        l->next    = NULL;
        list       = l;
        #ifdef DEBUG_GACC
            printf ("Cration de la liste %x ------>\n", list);
        #endif
    }
    #ifdef DEBUG_GACC
        printf ("Ajout de l'lment %x dans la liste %x\n", element, list);
    #endif
    return list;
}

void my_list_free (MY_LIST *list) {
    MY_LIST *l = list;
    MY_LIST *m = NULL;
    int      i = 0;

    while (l != NULL) {
        i++;
        m = l->next;
        #ifdef DEBUG_GACC
            printf ("Suppression de l'lment n%d (%x) de la liste (%x)\n",
                    i, l->element, list);
        #endif
        free (l);
        l = m;
    }
    list = NULL;
}

void *my_list_get_element (MY_LIST *list, int element) {
    MY_LIST *l = list;
    int      i = 0;

    while ( (l != NULL) && (i != element) ) {
        l = l->next;
        i++;
    }
    #ifdef DEBUG_GACC
        printf ("Rcupration de l'lment %d (%x) de la liste %x\n",
                element, l != NULL ? l->element : NULL, list);
    #endif
    if (l != NULL) return l->element;
    return NULL;
}
