/*****************************************************************************
     This file is part of FWatch. 

     Copright (C)2003  Frank Hemer <frank@hemer.org>

     FWatch is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation; either version 2 of the License, or
     (at your option) any later version.

     FWatch is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with FWatch; if not, write to the Free Software
     Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*******************************************************************************/

/* $Id: fwatchread.c,v 1.2 2003/05/18 19:28:43 frank Exp $ */ 

#include <stdio.h> 
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <errno.h> 
#include <unistd.h>

#include "fwatch.h"

#include <assert.h>


#define MAX_READ 512
#define SLEEP_WAIT 200

typedef char * cbuff;

char * fop(int func) {

  switch( func) {

    case FWATCH_OPENW:
      return "OPENW";
    case FWATCH_OPENR:
      return "OPENR";
    case FWATCH_RMDIR:
      return "RMDIR";
    case FWATCH_MKDIR:
      return "MKDIR";
    case FWATCH_SYMLINK:
      return "SYMLINK";
    case FWATCH_LINK:
      return "LINK";
    case FWATCH_UNLINK:
      return "UNLINK";
    case FWATCH_CREATE:
      return "CREATE";
    case FWATCH_CLOSE:
      return "CLOSE";
    case FWATCH_RENAME:
      return "RENAME";
    case FWATCH_CHOWN:
      return "CHOWN";
    case FWATCH_CHMOD:
      return "CHMOD";
    case FWATCH_STAT:
      return "STAT";
    case FWATCH_FSTAT:
      return "FSTAT";
    case FWATCH_UTIME:
      return "UTIME";
    default:
      return "UNKNOWN";
  }

}

main (int argc, char **argv)
{

  int fd; 

  (void)unlink("/dev/fwatch");
  if (mknod("/dev/fwatch", S_IFCHR | 0600, makedev(40, 0)) == -1) {
    printf("can't create %s: %m", "/dev/fwatch");
    exit(-1);
  }

  fd=open("/dev/fwatch", O_RDONLY | O_NONBLOCK); 


  ioctl(fd,FWATCH_SETMODE, FWATCH_OPENW |
	FWATCH_OPENR |
	FWATCH_RMDIR |
	FWATCH_MKDIR |
	FWATCH_SYMLINK |
	FWATCH_LINK |
	FWATCH_UNLINK |
	FWATCH_CREATE |
	FWATCH_CLOSE |
	FWATCH_RENAME |
	FWATCH_CHOWN |
	FWATCH_CHMOD |
	FWATCH_STAT |
	FWATCH_FSTAT |
	FWATCH_UTIME);

/*  ioctl(fd,FWATCH_SETMODE, FWATCH_FSTAT); */

/*   (void)unlink("/dev/fwatch"); */

  if ( fd < 0 ) { 
    printf("Could not open /dev/fwatch: %s\n", strerror(errno)); 
    exit(-1);
  }

  while ( 1 ) { 

    fd_set rfds;
    struct timeval tv;
    int retval;

    /* Watch stdin (fd 0) to see when it has input. */
    FD_ZERO(&rfds);
    FD_SET(fd, &rfds);
    /* Wait up to five seconds. */
    tv.tv_sec = 5;
    tv.tv_usec = 0;
    
    retval = select(fd+1, &rfds, NULL, NULL, &tv);
    /* Don't rely on the value of tv now! */
    
    if (retval) {
/*       printf("Data is available now.\n"); */
    /* FD_ISSET(0, &rfds) will be true. */

      fwatch_data_t readbuf[20];
      int rc = read(fd, readbuf, sizeof readbuf);
      if (rc < 0) {
	printf("error rc<0\n");
      } else {
	int i = 0;
	assert(rc % sizeof (fwatch_data_t) == 0);
	rc /= sizeof (fwatch_data_t);
	for (i = 0; i < rc; i++) {

#ifdef FWATCH_HAVENAMES
	  printf("Notify: %s: %s, %s, dev: %d/%d, inode: %ld, pname: %s, pdev: %d/%d, pinode: %ld\n",
		 fop[readbuf[i].func],
		 readbuf[i].name,
		 readbuf[i].mask == FWATCH_ISFILE ? "FILE\0" : "NOFILE\0",
		 major(readbuf[i].st_dev),
		 minor(readbuf[i].st_dev),
		 readbuf[i].st_ino,
		 readbuf[i].pname,
		 major(readbuf[i].st_pdev),
		 minor(readbuf[i].st_pdev),
		 readbuf[i].st_pino); 
#else
	  printf("Notify: %s: %s, dev: %d/%d, inode: %ld, pdev: %d/%d, pinode: %ld\n",
		 fop(readbuf[i].func),
		 readbuf[i].mask == FWATCH_ISFILE ? "FILE\0" : "NOFILE\0",
		 major(readbuf[i].st_dev),
		 minor(readbuf[i].st_dev),
		 readbuf[i].st_ino,
		 major(readbuf[i].st_pdev),
		 minor(readbuf[i].st_pdev),
		 readbuf[i].st_pino);
#endif
	}
      }
    }
  }
  exit(0); 
}

