# Module: about.tcl
# Tcl version: 7.6 (Tcl/Tk/XF)
# Tk version: 4.2
# XF version: 4.0
#

# module contents
global moduleList
global autoLoadList
set moduleList(about.tcl) { .top0 .top4 FtapeToolVersion}
set autoLoadList(about.tcl) {1}

# procedures to show toplevel windows


# procedure to show window ShowWindow.top0
proc ShowWindow.top0 { args} {
# xf ignore me 7

  # build widget .top0
  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy .top0"
  } {
    catch "destroy .top0"
  }
  toplevel .top0 

  # Window manager configurations
  wm positionfrom .top0 ""
  wm sizefrom .top0 program
  wm geometry .top0 412x357
  wm maxsize .top0 412 357
  wm minsize .top0 10 10
  wm title .top0 {About}
  wm resizable .top0 0 0


  # build widget .top0.frame1
  frame .top0.frame1  -borderwidth {2}  -height {30}  -relief {raised}  -width {30}

  # build widget .top0.frame1.button3
  button .top0.frame1.button3  -image {ftapetoolLOGO}  -padx {9}  -pady {3}  -state {active}  -text {button3}

  # build widget .top0.frame2
  frame .top0.frame2  -borderwidth {2}  -height {30}  -relief {raised}  -width {30}

  # build widget .top0.frame2.label5
  label .top0.frame2.label5  -relief {raised}  -text "[FtapeToolVersion] Copyright (c) Claus-Justus Heine 1998"

  # build widget .top0.frame2.button6
  button .top0.frame2.button6  -command {DestroyWindow.top0}  -padx {9}  -pady {3}  -text {OK}

  # pack master .top0.frame1
  pack configure .top0.frame1.button3

  # pack master .top0.frame2
  pack configure .top0.frame2.label5  -expand 1  -fill both  -side left
  pack configure .top0.frame2.button6  -side right

  # pack master .top0
  pack configure .top0.frame1  -expand 1  -fill both
  pack configure .top0.frame2  -fill x

  if {"[info procs XFEdit]" != ""} {
    catch "XFMiscBindWidgetTree .top0"
    after 2 "catch {XFEditSetShowWindows}"
  }
}

proc DestroyWindow.top0 {} {# xf ignore me 7
  if {"[info procs XFEdit]" != ""} {
    if {"[info commands .top0]" != ""} {
      global xfShowWindow.top0
      set xfShowWindow.top0 0
      XFEditSetPath .
      after 2 "XFSaveAsProc .top0; XFEditSetShowWindows"
    }
  } {
    catch "destroy .top0"
    update
  }
}


# procedure to show window ShowWindow.top4
proc ShowWindow.top4 { args} {
# xf ignore me 7

  # build widget .top4
  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy .top4"
  } {
    catch "destroy .top4"
  }
  toplevel .top4 

  # Window manager configurations
  wm positionfrom .top4 ""
  wm sizefrom .top4 user
  wm maxsize .top4 1000 1000
  wm minsize .top4 10 10
  wm title .top4 {COPYING}

  # build widget .top4.frame8
  frame .top4.frame8  -borderwidth {2}  -height {30}  -width {30}

  # build widget .top4.frame8.button9
  button .top4.frame8.button9  -command {DestroyWindow.top4}  -foreground {Blue}  -padx {9}  -pady {3}  -state {active}  -text {CLOSE}

  # build widget .top4.frame
  frame .top4.frame

  # build widget .top4.frame.scrollbar3
  scrollbar .top4.frame.scrollbar3  -command {.top4.frame.listbox1 xview}  -orient {horizontal}  -relief {raised}

  # build widget .top4.frame.scrollbar2
  scrollbar .top4.frame.scrollbar2  -command {.top4.frame.listbox1 yview}  -relief {raised}

  # build widget .top4.frame.listbox1
  listbox .top4.frame.listbox1  -relief {raised}  -width {60}  -xscrollcommand {.top4.frame.scrollbar3 set}  -yscrollcommand {.top4.frame.scrollbar2 set}

  # pack master .top4.frame8
  pack configure .top4.frame8.button9  -expand 1  -fill x

  # pack master .top4.frame
  pack configure .top4.frame.scrollbar2  -fill y  -side right
  pack configure .top4.frame.listbox1  -expand 1  -fill both
  pack configure .top4.frame.scrollbar3  -fill x  -side bottom

  # pack master .top4
  pack configure .top4.frame  -expand 1  -fill both
  pack configure .top4.frame8  -fill x

  if {"[info procs XFEdit]" != ""} {
    catch "XFMiscBindWidgetTree .top4"
    after 2 "catch {XFEditSetShowWindows}"
  }
}

proc DestroyWindow.top4 {} {# xf ignore me 7
  if {"[info procs XFEdit]" != ""} {
    if {"[info commands .top4]" != ""} {
      global xfShowWindow.top4
      set xfShowWindow.top4 0
      XFEditSetPath .
      after 2 "XFSaveAsProc .top4; XFEditSetShowWindows"
    }
  } {
    catch "destroy .top4"
    update
  }
}


# User defined procedures


# Procedure: FtapeToolVersion
proc FtapeToolVersion {} {
    source [FtapeToolDir]/version.tcl
    return $VersionString
}


# Internal procedures

# eof
#

