#ifndef _FTTOOLS_DATA_ACCESS_H_
#define _FTTOOLS_DATA_ACCESS_H_

#include <swab.h>

#define PUT2(ptr, off, val) \
{ u_int16_t _val = cpu_to_le16(val); memcpy((u_int8_t *)ptr + off, &_val, 2); }
#define PUT4(ptr, off, val) \
{ u_int32_t _val = cpu_to_le32(val); memcpy((u_int8_t *)ptr + off, &_val, 4); }
#define PUT8(ptr, off, val) \
{ u_int64_t _val = cpu_to_le64(val); memcpy((u_int8_t *)ptr + off, &_val, 8); }
#define GET2(ptr, off) \
({ u_int16_t _r; memcpy(&_r, (u_int8_t *)ptr + off, 2); le16_to_cpu(_r); })
#define GET4(ptr, off) \
({ u_int32_t _r; memcpy(&_r, (u_int8_t *)ptr + off, 4); le32_to_cpu(_r); })
#define GET8(ptr, off) \
({ u_int64_t _r; memcpy(&_r, (u_int8_t *)ptr + off, 8); le64_to_cpu(_r); })

#endif
