
     FLIP(1)                  REFERENCE MANUAL              FLIP(1)


     NAME
          flip - do newline conversions between **IX and MS-DOS

     SYNOPSIS
          flip -h
          flip -umvtsbz file ...

     DESCRIPTION
          Flip is a file interchange program that converts text file
          formats between **IX and MS-DOS.  It converts lines ending
          with carriage-return (CR) and linefeed (LF) to lines ending
          with just linefeed, or vice versa.

          Flip has the following features.

          o    If a file contains isolated CR characters for
               underlining or overprinting, flip does not change them.

          o    When asked to convert a file to the same format that it
               already has, flip causes no change to the file.  Thus
               to convert all files to **IX format you can type

                    flip -u *.*  (under MS-DOS)
                    flip -u *    (under **IX)

               and all files will end up right, regardless of whether
               they were in MS-DOS or in **IX format to begin with.
               This also works in the opposite direction.

          o    Flip preserves file timestamps.  You can override this.

          o    Flip is written in C and will compile and run under
               MS-DOS/Turbo C, 4.3BSD, and System V.

          o    Flip accepts wildcards and multiple filenames on the
               command line.

          o    If a user interrupt aborts Flip, it does not leave
               behind any garbage files or cause corruption of the
               files being converted.

          o    Flip will normally refuse to convert binary files.  You
               can override this.

          o    When converting from MS-DOS to **IX format, flip
               removes any trailing control Z (the last character in
               the file), but leaves embedded control Z characters
               unchanged.  This minimizes the possibility of
               accidentally converting a binary file that contains a
               control Z near the beginning.  You can override this
               and ask flip to recognize the first control Z found as
               end-of-file.

          o    Flip can be asked to strip the high (parity) bit as it
               converts a file.

          Flip is normally invoked as:

               flip -umhvtb file ...

          One of -u, -m, or -h is required.  Switches may be given
          separately or combined together after a dash.  For example,
          the three command lines given below are equivalent:

               flip -uvt *.c
               flip -u -v -t *.c
               flip -u -vt *.c

          The meanings of the switches are as follows.

          -u   convert to **IX format (CR LF => LF, lone CR or LF
               unchanged, trailing control Z removed, embedded control
               Z unchanged)

          -m   convert to MS-DOS format (lone LF => CR LF, lone CR
               unchanged)

          -h   give a help message

          -v   be verbose, print filenames as they are processed

          -t   touch files (don't preserve timestamps)

          -s   strip high bit

          -b   convert binary files too (else binary files are left
               unchanged)

          -z   truncate file at first control Z encountered

          On systems that allow a program to know its own name, flip
          may be renamed (or linked) to a file called toix (or
          toix.exe under MS-DOS) for conversion to **IX format, or to
          a file called toms (or toms.exe under MS-DOS) for conversion
          to MS-DOS format.  When invoked with the name toix or toms,
          flip will act as if it were invoked with the -u or -m option
          respectively.

     COPYRIGHT
          Both this documentation and flip are Copyright 1989 Rahul
          Dhesi, all rights reserved.  Permission is granted to copy,
          use, and distribute for any commercial or noncommercial
          purpose in accordance with the requirements of version 1.0
          of the GNU General Public license.

          Note:  This software has not been endorsed by the Free
          Software Foundation, the creator of the GNU license, and I
          am not affiliated with that organization.

     AUTHOR
          Rahul Dhesi

     DATE
          This manual was formatted 1989/04/07.  It is for version
          1.00 of flip.
