// Image.cc for fbdesk
// Copyright (c) 2002-2003 Henrik Kinnunen (fluxgen at users.sourceforge.net)
// 
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the "Software"),
// to deal in the Software without restriction, including without limitation
// the rights to use, copy, modify, merge, publish, distribute, sublicense,
// and/or sell copies of the Software, and to permit persons to whom the
// Software is furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.

// $Id$

#include "Image.hh"

#include "ImageBase.hh"
#include "Surface.hh"

#include <iostream>
using std::cerr;
using std::endl;

using std::string;

namespace FbTk {

Image &Image::instance() {
    static Image singleton;
    return singleton;
}

void Image::add(ImageBase &img, const std::string &tag) { 
#ifdef DEBUG
    cerr<<"Register: "<<tag<<","<<&img<<endl;
#endif
    m_imagelist.insert(ImageList::value_type(tag, &img));
}

void Image::remove(ImageBase &img) {
    // m_imagelist.erase(&img);
}

Image::Image() {

}

Image::~Image() {

}


Surface *Image::load(const char *filename) {
    if (filename == 0)
        return 0;
    Image &img = Image::instance();
    string ext(img.findExtension(filename));

    ImageBase *base = img.findImageBase(ext);
	
    if (base != 0) {
        Surface *retsurf = base->load(filename);
        if (retsurf == 0)
            cerr<<"Failed to load file: "<<filename<<endl;
        return retsurf;
    }
	
    return 0;
}

bool Image::save(const char *filename, const Surface &img) {
    Image &image = Image::instance();
    string ext(image.findExtension(filename));
    ImageBase *base = image.findImageBase(ext);
	
    if (base)
        return base->save(filename, img);
	
    return false;
}

/**
   Parses the extension out of the filename
   @return the string of extension
*/
string Image::findExtension(const char *filename) {

    unsigned int i=0;
	
    //get start of extension
    for (i=strlen(filename); i>0 && filename[i] != '.'; i--);
	
    string ext;	
    for (i++;i<strlen(filename); i++)	//parse extension
        ext+=filename[i];
	
    char tmpbuff[256];	//create temp buff
    memset(tmpbuff, 0, 256); //zero buffer
    if (ext.size()>256)	//extension over 256 chars is stupid
        return "";
	
    strncpy(tmpbuff, ext.c_str(), ext.size()); //copy string
		
    //convert extension to upper case
    for (i=0; i<ext.size(); i++) 
        if ( tmpbuff[i] >= 'a' && tmpbuff[i] <= 'z')
            tmpbuff[i] += 'A'-'a';
	
	
    ext=tmpbuff;	//copy the converted tmpbuff
    return ext;	//return extension
}

/**
   Tries to find a imagebase with the right extension
   returns imagebase pointer on success else 0
*/
ImageBase *Image::findImageBase(const string& ext) {
    return Image::instance().m_imagelist[ext];
}

}; //end namespace FbTk
