/***************************************************************************
                          firsttimesetupwizardimp.cpp  -  description
                             -------------------
    begin                : Sat Feb 2 2002
    copyright            : (C) 2002 by Ral Alexis Betancort Santana
    email                : rabs@dimension-virtual.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "firsttimesetupwizardimp.h"
#include <qsqldatabase.h>
#include <qstringlist.h>
#include <qcombobox.h>
#include <qmessagebox.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qtextbrowser.h>
#include <qsettings.h>

FirstTimeSetupWizardImp::FirstTimeSetupWizardImp(QWidget *parent, const char *name ) : FirstTimeSetupWizard(parent,name,true) {
	// Disable the Help button on the first Page.
	setHelpEnabled(Info1,false);
	// Set the validation function of the Port QLineEdit widget.
	Port->setMaxLength(5);
	PortValidator = new QIntValidator(1,65534,Port);
	Port->setValidator(PortValidator);
	// TODO
	// Connect the helpClicked signal to the proper handler
	// Connect the FinishButton::accept() to our internal handler
//	QPushButton *FinishButton = finishButton();
//	connect(FinishButton,SIGNAL(clicked()),this,SLOT(FinishedClicked()));

	// Fill DatabaseDriver ComboBox with the available SQL drivers
	QStringList AvalilableDrivers;
	QSqlDatabase *TestDrivers = QSqlDatabase::addDatabase("QPSQL7");
	if (TestDrivers) {
  	AvalilableDrivers.append("PostgreSQL");
	}
	// Check for other SQL Drivers
	// TODO

	// Fill the ComboBox with the list
	DatabaseDriver->insertStringList(AvalilableDrivers);
}

FirstTimeSetupWizardImp::~FirstTimeSetupWizardImp(){
}

// Overloaded virtual slot
void FirstTimeSetupWizardImp::next(){
	
	// We must check the fields of the SetupDatabaseAccess "Page"
	if (indexOf(currentPage()) == indexOf(SetupDatabaseAccess)) {
		QString Text;
		Text = Username->text();
		// Empty or null username ?
		if (Text.isNull() || Text.isEmpty()) {
			// Not valid database username
			QMessageBox::critical(this,tr("Configuracin Inicial"),tr("Debe de indicar un nombre de usuario."));
			return;
		}
		Text = Password->text();
		// Empty or null password ?
		if (Text.isNull() || Text.isEmpty()) {
			// Not valid, we don't allow null's passwords
			QMessageBox::critical(this,tr("Configuracin Inicial"),tr("Debe de indicar una palabra de paso."));
			return;
		}
		Text = DBName->text();
		// Empty or null Database Name ?
		if (Text.isNull() || Text.isEmpty()) {
			// Not valid database name
			QMessageBox::critical(this,tr("Configuracin Inicial"),tr("Debe de indicar un nombre de base de datos a la que conectar."));
			return;
		}
		Text = Server->text();
		// Empty or null Server Name ?
		if (Text.isNull() || Text.isEmpty()) {
			// Not valid
			QMessageBox::critical(this,tr("Configuracin Inicial"),tr("Debe de indicar un nombre de maquina o una direccin IP\ndel servidor contra el que conectar."));
			return;
		}
		// FIXME
		// In Range port number ?
		Text = Port->text();
		int i=0;
		if (PortValidator->validate(Text,i) != QValidator::Acceptable) {
			// Not valid
			QMessageBox::critical(this,tr("Configuracin Inicial"),tr("Debe de indicar un nmero de puerto vlido"));
			return;
		}
	}
	QWizard::next();
	if (indexOf(currentPage()) == indexOf(TestingAccess)) {
		if (!checkDB()) {
			// If all is ok, activate the finish button.
			setFinishEnabled(TestingAccess,true);
			}
	}
}

///** This fuction is called when the FinishButton of the Wizard is clicked */
//void FirstTimeSetupWizardImp::FinishedClicked(){
//	// Supposed all is ok, save the params and lets continue
//	config->setGroup("DBA");
//	config->writeEntry("hostname",Server->text());
//	config->writeEntry("port",Port->text());
//	config->writeEntry("username",Username->text());
//	config->writeEntry("password",Password->text());
//	config->writeEntry("database",DBName->text());
//	emit FinishedOk();
//}

/** No descriptions */
void FirstTimeSetupWizardImp::reject(){
	int res;
	
	res = QMessageBox::information(this,tr("Asistente de configuracin inicial"),tr("Est seguro de querer abandonar este asistente?\n"),QMessageBox::Ok,QMessageBox::Cancel);
	if ( res == QMessageBox::Ok) {
		emit FinishedNotOk();
		QDialog::reject();
	}
}

/** Called when the Finish button is clicked */
void FirstTimeSetupWizardImp::accept(){
	QSettings config;
       QString keybase("/facturalux/" VERSION "/");

	// Suppose all is ok, save the params and lets continue
	config.writeEntry( keybase + "DBA/hostname",Server->text());
	config.writeEntry( keybase + "DBA/port",Port->text());
	config.writeEntry( keybase + "DBA/username",Username->text());
	config.writeEntry( keybase + "DBA/password",Password->text());
	config.writeEntry( keybase + "DBA/database",DBName->text());
	config.writeEntry( keybase + "First Time Setup", true);
	
	QDialog::accept();
}
/** No descriptions */
int FirstTimeSetupWizardImp::checkDB(){
	// Time to test if could made a conection to the database
	QString Driver;

	if (!QString::compare(DatabaseDriver->currentText(),QString("PostgreSQL"))) {
		Driver = QString("QPSQL7");
	}
	TestResults->setText(tr("Cargando driver de la base de datos... "));
	QSqlDatabase *TestDrivers = QSqlDatabase::addDatabase(Driver);
	if (TestDrivers) {
		TestResults->append(tr("Ok\n"));
		TestResults->append(tr("Comprobando conexin a la base de datos... "));
		TestDrivers->setHostName(Server->text());
		TestDrivers->setPort(Port->text().toInt());
		TestDrivers->setDatabaseName(DBName->text());
		TestDrivers->setUserName(Username->text());
		TestDrivers->setPassword(Password->text());
		if (TestDrivers->open()) {
			TestResults->append(tr("Ok\n"));
		} else {
			TestResults->append(tr("Error: Pulse en Atrs y compruebe su configuracin."));
			return 1;
		}
	} else {
		TestResults->append(tr("Error: Imposible cargar el driver seleccionado."));
		return 1;
	}
	return 0;
}
