/***************************************************************************
                          FLDataTable.h  -  description
                             -------------------
    begin                : Sun Jul 1 2001
    copyright            : (C) 2001,2002 by Federico Albujer Zornoza
    email                : mail@infosial.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef FLDATATABLE_H
#define FLDATATABLE_H

#include <qdatatable.h>
#include <qpainter.h>
#include <qpixmapcache.h>
#include <qdatetime.h>
#include <qcolor.h>

class FLSqlCursor;

/** 	Clase que es una redefinicion de la clase QDataTable,
    	especifica para las necesidades de FacturaLUX.

    	@author		Federico Albujer Zornoza
    	@version  	0.4 */
class FLDataTable :  public QDataTable
{
	Q_OBJECT

	public:

	/** constructor */
  	FLDataTable (QWidget * parent = 0, const char *name = 0);

	/** desctructor */
   	~FLDataTable ();

	/** Establece el valor del cursor */
  	void setFLSqlCursor (FLSqlCursor * c);

    /** Establece la tabla a slo lectura */
    void setReadOnly()
    {
        readonly_ = true;
     }

    /** Establece la tabla a slo lectura */
    void setInsertOnly(bool mode)
    {
        insertonly_ = mode;
    }

	protected:

	/** 	Filtrado de eventos */
   	bool eventFilter (QObject * o, QEvent * e);

	/** 	Redefinido por conveniencia para pintar la celda */
  	void paintCell (QPainter * p, int row, int col, const QRect & cr, bool selected, const QColorGroup & cg);

	/** 	Redefinido por conveniencia para pintar el campo */
  	void paintField (QPainter * p, const QSqlField * field, const QRect & cr,bool);

 	 /** 	Redefinido por conveniencia, para evitar que aparezca el menu contextual
		con las opciones para editar registros */
  	void contentsContextMenuEvent (QContextMenuEvent * e);

  	/** 	Redefine por conveniencia, el comportamiento al hacer doble clic sobre una
		celda */
  	void contentsMouseDoubleClickEvent (QMouseEvent * e);

       /** Redefinida por conveniencia */
   void focusOutEvent( QFocusEvent * );

	private:

	/** 	Numero de la fila (registro) seleccionada actualmente */
  	int rowSelected;

	/** 	Numero de la columna (campo) seleccionada actualmente */
  	int colSelected;

	/** 	Cursor, con los registros */
  	FLSqlCursor *cursor_;

    /** Almacena la tabla est en modo slo lectura */
    bool readonly_;

	/** Indica si la tabla est en modo "insertonly", es decir,slo permitimos aadir registros*/
	bool insertonly_;

  	public slots:
	
	/** 	Selecciona la fila completa en la que est la celda activa.

		Implcitamente (sin no se indican parmetros), selecciona
		la fila correspondiente al registro activo del cursor.

		@param r 	Fila de la celda activa.
		@param c 	Columna de la celda activa. */
  	void selectRow (int r = -1, int c = -1);

   /** Redefinida por conveniencia */
   void setFocus();

	signals:
	
	/** 	Indica que se ha elegido un registro, mediante doble clic sobre
	    	l o bien pulsando la tecla Enter */
  	void recordChoosed ();
};

#endif
