# (C) Copyright IBM Corp. 2004
#
# This program is free software;  you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY;  without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
# the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program;  if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
#
# Perl module with common subroutines for managing BBR segments.

package Evms::BBR;

use strict;
use warnings;

use Evms::Common;
use Evms::Object;

BEGIN {
	use Exporter();
	our (@ISA, @EXPORT);
        @ISA = qw(Exporter);
        @EXPORT = qw(&assign_bbr_plugin
		     &unassign_bbr_plugin
		     &create_bbr_segment
		    );
}

# assign_bbr_plugin
#
# Arguments:
#    disk: Disk (or segment) to assign the BBR plugin to.
sub assign_bbr_plugin($)
{
        my $disk = $_[0];
        my $command = "assign:BBRseg={},$disk";
        my $rc;

        $rc = run_evms_command($command);

        return $rc;
}

# unassign_bbr_plugin
#
# Arguments:
#    disk: Disk (or segment) to unassign the BBR plugin from.
sub unassign_bbr_plugin($)
{
	my $disk = $_[0];
	my $command = "remove:$disk";
	my $rc;

	$rc = run_evms_command($command);

	return $rc;
}

# create_bbr_segment
#
# Arguments:
#    disk: Disk (or segment) to create the BBR segment on.
sub create_bbr_segment($)
{
	my $disk = $_[0];
	my $rc;

	$rc = assign_bbr_plugin($disk);

	return $rc;
}

1;

