#!/usr/bin/env entity
<object>
  <window ondelete="entity:exit">
    <vbox name="container"/>
  </window>
<?python
# the tests
def test_print(node):
    print node
def test_enode_crap1(node):
    print enode(32, 'kitten')
def test_enode_object(node):
    print enode('object')
def test_attrib_get(node):
    print node.attrib('name')
def test_attrib_set(node):
    print node.attrib({'label':'arlsls'})
def test_index_get(node):
    print node['name']
def test_index_set(node):
    node['label'] = foo    
def test_type(node):
    print node.type()
def test_path(node):
    print node.path()
def test_basename(node):
    print node.basename()
def test_description(node):
    print node.description()
def test_attrib_possible_values(node):
    print node.attrib_possible_values()
def test_attrib_value_type(node):
    print node.attrib_value_type()
def test_nonexistant_attrib(node):
    print node["asdfasfd"]
    print node.attrib("asdflfasdf")


# add in test buttons
tests = {
    "print node":           test_print,
    "enode(32, 'kitten')":  test_enode_crap1,
    "enode('object')":      test_enode_object,
    "node.attrib('name')":  test_attrib_get,
    "node.attrib({'label':'arlsls'})": test_attrib_set,
    "node['name']":         test_index_get,
    "node['label']='foo'":  test_index_set,
    "type()":               test_type,
    "path()":               test_path,
    "basename()":           test_basename,
    "description()":        test_description,
    "attrib_possible_values()": test_attrib_possible_values,
    "attrib_value_type()":   test_attrib_value_type,
    "nonexistant_attrib()":   test_nonexistant_attrib,
    }
  

def dotest(node, counts= {}):
    print "getting button label."
    thisnode = node.attrib("label")
    print "label was %s" % thisnode
    try:
        count = counts[thisnode]
    except:
        count = 0
    print "count was %i" % count

    func = tests[thisnode]
    print "got func: %s, calling" % repr(func)
    try:
        func(node)
    finally:
        print "called."
        
    count = count +1
    counts[thisnode] = count
    print "This is execution %i of %s" % (count, thisnode)
    label = node.parent().child('label')
    label.attrib({'text':'%i'%count})

def add_test(parent, label):
    node = parent.new_child("hbox");
    node.append_xml('<label text="0"/><button label="%s" onclick="py:dotest"/>' % label)    

node = enode("vbox.container")
for label in tests.keys():
    add_test(node, label)
    

?>
</object>
