/*
 * Copyright (C) 2002,2003 Daniel Heck
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: sound.hh,v 1.6 2003/07/07 21:14:05 reallysoft Exp $
 */
#ifndef SOUND_HH
#define SOUND_HH

#include "SDL_mixer.h"
#include "px/math.hh"

namespace sound
{
    void Init();
    void Shutdown();

    void DisableSound();
    void EnableSound();
    void DisableMusic();

    void TempDisableSound();
    void TempReEnableSound();

    void SetListenerPosition (const px::V2 &pos);
    void PlaySound (const char *name, const px::V2 &pos);

    void PlaySound(const char *name);
    void PlayMusic(const char *name);
    void FadeoutMusic();
    void StopMusic();
    void StopMusic(const char *name);

    /* This function converts raw audio data with a specified format
       to the mixer's audio format.  This is used for converting the
       original Oxyd sounds to a format usable by Enigma. */
    Mix_Chunk *ChunkFromRaw (const Uint8 *buf, Uint32 len,
                             int freq, int format, int channels);

    void ClearSoundCache();

    /* Set the sound and music volume according to the settings in
       namespace options:: */
    void UpdateVolume();
}

#endif
