/*
 * Copyright (C) 2002,2003 Daniel Heck
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: oxyd.hh,v 1.8 2003/06/25 19:34:49 reallysoft Exp $
 */
#ifndef ENIGMA_OXYD_HH
#define ENIGMA_OXYD_HH

#include "oxydlib/DatFile.h"
#include "oxydlib/OxydVersion.h"
#include "enigma.hh"
#include "game.hh"
#include "SDL_mixer.h"

namespace enigma {
    namespace oxyd
    {
        void Init();
        void Shutdown();

        bool FoundOxyd (OxydLib::OxydVersion ver);

        /* Toggle used soundset */
        void ChangeSoundset(int sound_set, int default_sound_set);

        /* This function tries to load a sound sample from Oxyd's data
           file.  Returns 0 if none could be found. */
        Mix_Chunk *LoadSound (const std::string &name);
    }
}

#endif
