/*****************************************************************************
 * Author:   Valient Gough <vgough@pobox.com>
 *
 *****************************************************************************
 * Copyright (c) 2004, Valient Gough
 *
 * This library is free software; you can distribute it and/or modify it under
 * the terms of the GNU General Public License (GPL), as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GPL in the file COPYING for more
 * details.
 */

#include "NullNameIO.h"

#include "Cipher.h"
#include "base64.h"


NullNameIO::NullNameIO( )
{

}

NullNameIO::~NullNameIO()
{
}

int NullNameIO::maxEncodedNameLen( int plaintextNameLen ) const
{
    return plaintextNameLen;
}

int NullNameIO::maxDecodedNameLen( int encodedNameLen ) const
{
    return encodedNameLen;
}

int NullNameIO::encodeName( const char *plaintextName, int length,
	char *encodedName ) const
{
    memcpy( encodedName, plaintextName, length );

    return length;
}

int NullNameIO::decodeName( const char *encodedName, int length,
	char *plaintextName ) const
{
    memcpy( plaintextName, encodedName, length );

    return length;
}



