#ifndef __DEBUG_H__
#define __DEBUG_H__ 1
/* 
   elmo - ELectronic Mail Operator

   Copyright (C) 2002, 2003 rzyjontko

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

*/
/*****************************************************************************
 *    INTERFACE REQUIRED HEADERS
 ****************************************************************************/
/*****************************************************************************
 *    INTERFACE DEFINITIONS / ENUMERATIONS / SIMPLE TYPEDEFS
 ****************************************************************************/

enum level {
        DEBUG_ERROR,
        DEBUG_WARN,
        DEBUG_INFO,
};

#ifndef __GNUC__
# define DFORMAT
#else
# define DFORMAT __attribute__ ((format (printf, 2, 3)))
#endif

/****************************************************************************
 *    INTERFACE CLASS PROTOTYPES / EXTERNAL CLASS REFERENCES
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE STRUCTURES / UTILITY CLASSES
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE DATA DECLARATIONS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE FUNCTION PROTOTYPES
 ****************************************************************************/

#ifdef __cplusplus
extern "C" {
#endif

extern void debug_start (void);
extern void debug_end (void);
extern void debug_msg (enum level level, const char *fmt, ...) DFORMAT;

/** scroll down */
extern void debug_next (void);
/** scroll up */
extern void debug_prev (void);
/** scroll down one page */
extern void debug_next_page (void);
/** scroll up one page */
extern void debug_prev_page (void);
/** scroll to the top */
extern void debug_first (void);
/** scroll to the bottom */
extern void debug_last (void);
/** refresh the view */
extern void debug_show (void);

#ifdef __cplusplus
}
#endif

/****************************************************************************
 *    INTERFACE OBJECT CLASS DEFINITIONS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE TRAILING HEADERS
 ****************************************************************************/
/****************************************************************************
 *
 *    END HEADER debug.h
 *
 ****************************************************************************/
#endif
