

/**
 * An abstract class for objects which create a user interface. Methods of thie
 * class will be called at critical points in the generation of the index. The
 * derived class should handle them and produce some sort of output.
 */
public interface UserInterface{

	/**
	 * This is called whenever an error occurs. Note that these may nt be fatal
	 * errors. 
	 * @param message The full formatted message, as will appear in the log
	 * @param errorNo The number of the error, to be cross referenced with
	 * documentation.
	 * @param resourceID identifier for the resource in MainStrings.properties
	 * @param params Additional parameters supplied by the caller.
	 */
	public void error(String message, int errorNo, String resourceID, Object[] params);
	
	/**
	 * This is called whenever a warning is issued. Note that these may nt be fatal
	 * errors. 
	 * @param message The full formatted message, as will appear in the log
	 * @param errorNo The number of the error, to be cross referenced with
	 * documentation.
	 * @param resourceID identifier for the resource in MainStrings.properties
	 * @param params Additional parameters supplied by the caller.
	 */
	public void warning(String message, int warningNo, String resourceID, Object[] params);
	
	/**
	 * This indicates that the scanning of the files is about to begin
	 */
	public void startScan();

	/**
	 * This is a progress report for the scaning of the files.
	 * @param complete Number of files scaned so far.
	 * @param current Current File
	 */
	public void scanProgress(String current);

	/**
	 * This indicates that the scanning of the files has completed and the
	 * output is about to be generated.
	 */
	public void startOutputGenerate();
	
	/**
	 * This is called when the process has finished. Might be useful for
	 * reporting data collected during the process.
	 */
	public void finished();
}
