import java.io.File;
import java.io.IOException;
import gnu.regexp.*;

/**
 * Class from which all index generators are derived. 
 * Current plans are for just  * sitemap and Ordered List index typs to be
 * derived from this class, however this may change with time.
 * <br>$Id: AnyIndexGen.java,v 1.10 2002/09/24 14:32:49 howama Exp $
 *
 * TODO: l10n work throughout
 */
public abstract class AnyIndexGen{
	/**
	 * Starts the generation process. It is safe to assume that the file list
	 * has already been created and all details have been derived from the html
	 * files.
	 */
	abstract void generate() throws java.io.IOException, IllegalVariableException, REException, org.apache.oro.text.regex.MalformedPatternException;	
	
	/**
	 * Determines whether the output file is acceptable. 
	 * @param log the log to report details in
	 * @param fileName the to test
	 * @return true if processing should continue using this file.
	 */
	protected static boolean outFileAcceptable(IGLog log, String fileName){
		log.add(8, "Testing output file, "+fileName);
		File outFile = new File( fileName );
		/* 
		 * Look for fatal errors with output file
		 */
		if (outFile.isDirectory()){
			log.add(1, "Output file is a directory");
			return false;
		}else if (outFile.exists()){
			if(!outFile.canWrite()){
				log.add(1, "Output file is not writeable");
				return false;	
			}
		}else if (!outFile.exists()){
			log.add(9, "Output file doesn't exist");
//			try{
//				File path = new File( outFile.getAbsolutePath() );
				/*
				 * TODO:
				 *  FIX THIS. I can't see why it doesn't work (yes, I do know
				 *  it's commented out)
				 *  
				if (!path.exists()){
					log.add(1, "Output directory does not exist: " + path.getName());
					return false;
				}
				if (!path.canWrite()){
					log.add(1, "Cannot write to output directory");
					return false;
				}
				*/
//			}catch (IOException e){
//				log.add(1, "IOException when trying to test output directory: "+e);
//			}
		}

		
		/*
		 * Look for possible problems with output file and issue warnings
		 */
		if (outFile.isHidden()){
			log.add(2, "Output file is hidden");
		}
		if (outFile.exists()){
			log.addWarning(15, "OUTPUT_FILE_EXISTS", new Object[] {fileName, fileName+".indexgen"});
			if (!outFile.renameTo( new File( fileName+".indexgen" ) )){
				log.addError(16, "OUT_FILE_RENAME_ERROR", null);
				return false;
			}
		}
		return true;
	}
}
