<?xml version='1.0'?>
<!-- vim: sw=2 sta et
-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:doc="http://nwalsh.com/xsl/documentation/1.0"
                version='1.0'
                xml:lang="en">

<!-- ********************************************************************
     $Id: param.xsl,v 1.27 2004/07/16 02:50:38 stevecheng Exp $
     ********************************************************************

     &copy; 2000-2001 Steve Cheng <stevecheng@users.sourceforge.net>

     This file is part of the docbook2X XSLT stylesheets for
     converting DocBook to Texinfo.

     Originally derived from Norman Walsh's XSL DocBook Stylesheet
     Distribution.

     ******************************************************************** -->

<!-- ==================================================================== -->

<doc:reference xmlns="">
<title>Stylesheet parameters</title>
<partintro>
<para>
Stylesheet parameters influence various aspects of the rendering.  They
can be set from the command line (the exact syntax depends on the XSLT
processor), or in a custom stylesheet.  
</para>

<para>
To set them in a custom stylesheet, simply copy the definition here and
change the <sgmltag class="attribute">select</sgmltag> attribute to
something else.
</para>

<para>
If a parameter for what you want to change does not exist, you can write
templates in the custom stylesheet instead.
</para>
</partintro>
</doc:reference>


<!-- ==================================================================== -->
<xsl:param name="captions-display-as-headings" select="false()" />
<doc:param name="captions-display-as-headings" xmlns="">
<refpurpose>Use heading markup for minor captions?</refpurpose>
<refdescription>
<para>If true, <sgmltag class="element">title</sgmltag>
content in some (formal) objects are rendered with the Texinfo
<markup>@<replaceable>heading</replaceable></markup> commands.
</para>
<para>
If false, captions are rendered as an emphasized paragraph.
</para>
</refdescription>
</doc:param>


<!-- ==================================================================== -->
<xsl:param name="menus-use-abstract" select="false()" />
<doc:param name="menus-use-abstract" xmlns="">
<refpurpose>Use plain <sgmltag class="element">abstract</sgmltag> for
menu descriptions?</refpurpose>
<refdescription>
<para>If true, <sgmltag class="element">abstract</sgmltag>s
for nodes will be rendered in the menu.  Otherwise, they are ignored.
</para>
</refdescription>
</doc:param>



<!-- ==================================================================== -->
<xsl:param name="links-use-pxref" select="true()" />

<doc:param name="links-use-pxref" xmlns="">
<refpurpose>Translate <sgmltag class="element">link</sgmltag> using
<markup>@pxref</markup></refpurpose>
<refdescription>
<para>
If true, <sgmltag class="element">link</sgmltag> is translated
with the hypertext followed by the cross reference in parentheses.
</para>
<para>
Otherwise, the hypertext content serves as the cross-reference name
marked up using <markup>@ref</markup>.  Typically info displays this
contruct badly.
</para>
</refdescription>
</doc:param>


<!-- ==================================================================== -->
<xsl:param name="explicit-node-names" select="false()" />

<doc:param name="explicit-node-names" xmlns="">
<refpurpose>Insist on manually constructed Texinfo node
names</refpurpose>
<refdescription>
<para>
Elements in the source document can influence the Texinfo node name
generation specifying either a <sgmltag
class="attribute">xreflabel</sgmltag>, or for the sectioning elements,
a <sgmltag class="element">title</sgmltag> with <sgmltag
class="attribute">role='texinfo-node'</sgmltag> in the 
<sgmltag class="element"><replaceable>*</replaceable>info</sgmltag> container.
</para>

<para>
However, for the majority of source documents, explicit Texinfo node
names are not available, and the stylesheet tries to generate a
reasonable one instead, e.g. from the normal title of an element.  
The generated name may not be optimal.  If this option is set and the
stylesheet needs to generate a name, a warning is emitted and 
<function>generate-id</function> is always used for the name.
</para>

<para>
When the hashtable extension is not available, the stylesheet cannot
check for node name collisions, and in this case, setting this option
and using explicit node names are recommended.  
</para>

<para>
This option is not set (i.e. false) by default.
</para>

<note>
<para>The absolute fallback for generating node names is using the XSLT
function <function>generate-id</function>, and the stylesheet always
emits a warning in this case regardless of the setting of
<parameter>explicit-node-names</parameter>.</para>
</note>

</refdescription>
</doc:param>

<!-- ==================================================================== -->
<xsl:param name="show-comments" select="true()"/>

<doc:param name="show-comments" xmlns="">
<refpurpose>Display <sgmltag>comment</sgmltag> elements?</refpurpose>
<refdescription>
<para>If true, comments will be displayed, otherwise they are suppressed.
Comments here refers to the <sgmltag>comment</sgmltag> element,
which will be renamed <sgmltag>remark</sgmltag> in DocBook V4.0,
not XML comments (&lt;-- like this --&gt;) which are unavailable.
</para>
</refdescription>
</doc:param>

<!-- ==================================================================== -->
<xsl:param name="funcsynopsis-style">ansi</xsl:param>

<doc:param name="funcsynopsis-style" xmlns="">
<refpurpose>What style of 'FuncSynopsis' should be generated?</refpurpose>
<refdescription>

<variablelist>

<varlistentry>
<term><literal>ansi</literal></term>
<listitem><para>Function prototypes in ANSI-C style</para></listitem>
</varlistentry>

<varlistentry>
<term><literal>kr</literal></term>
<listitem><para>K&amp;R-style function synopses</para></listitem>
</varlistentry>

</variablelist>

</refdescription>
</doc:param>

<!-- ==================================================================== -->
<xsl:param name="funcsynopsis-decoration" select="true()" />

<doc:param name="funcsynopsis-decoration" xmlns="">
<refpurpose>Decorate elements of a FuncSynopsis?</refpurpose>
<refdescription>
<para>If true, elements of the FuncSynopsis will be decorated (e.g. bold or
italic).  The decoration is controlled by functions that can be redefined
in a customization layer.
</para>
</refdescription>
</doc:param>

<!-- ==================================================================== -->
<xsl:param name="function-parens" select="false()" />

<doc:param name="function-parens" xmlns="">
<refpurpose>Generate parentheses after a function?</refpurpose>
<refdescription>
<para>If true, the formatting of
a <sgmltag class="starttag">function</sgmltag> element will include
generated parenthesis.
</para>
</refdescription>
</doc:param>

<!-- ==================================================================== -->
<xsl:param name="refentry-display-name" select="true()"/>

<doc:param name="refentry-display-name" xmlns="">
<refpurpose>Output NAME header before 'RefName'(s)?</refpurpose>
<refdescription>
<para>If true, a "NAME" section title is output before the list
of 'RefName's.
</para>
</refdescription>
</doc:param>


<!-- ==================================================================== -->
<xsl:param name="manvolnum-in-xref" select="true()"/>

<doc:param name="manvolnum-in-xref" xmlns="">
<refpurpose>Output <sgmltag>manvolnum</sgmltag> as part of
<sgmltag>refentry</sgmltag> cross-reference?</refpurpose>
<refdescription>
<para>if true, the <sgmltag>manvolnum</sgmltag> is used when cross-referencing
<sgmltag>refentry</sgmltag>s, either with <sgmltag>xref</sgmltag>
or <sgmltag>citerefentry</sgmltag>.
</para>
</refdescription>
</doc:param>





<!-- ==================================================================== -->
<xsl:param name="author-othername-in-middle" select="1"/>

<doc:param name="author-othername-in-middle" xmlns="">
<refpurpose>Is <sgmltag>othername</sgmltag> in <sgmltag>author</sgmltag> a
middle name?</refpurpose>
<refdescription>
<para>If true, the <sgmltag>othername</sgmltag> of an <sgmltag>author</sgmltag>
appears between the <sgmltag>firstname</sgmltag> and
<sgmltag>surname</sgmltag>.  Otherwise, <sgmltag>othername</sgmltag>
is suppressed.
</para>
</refdescription>
</doc:param>

<!-- ==================================================================== -->
<!-- Actual definition is in texifile.xsl; you may override it with
     a string literal:
     <xsl:param name="texinfo.filename.root" select="''">
-->

<xsl:param name="output-file" select="''" />
<doc:param name="output-file" xmlns="">
<refpurpose>Name of the Info file</refpurpose>
<refdescription>
<para>This parameter specifies the name of the final Info file,
overriding the setting in the document itself and the automatic
selection in the stylesheet.  If the document is a <sgmltag
class="element">set</sgmltag>, this parameter has no effect. </para>
<important>
<para>
Do <emphasis>not</emphasis> include the <literal>.info</literal>
extension in the name.
</para>
</important>
</refdescription>
</doc:param>


<!-- ==================================================================== -->
<xsl:param name="index-category" select="'cp'"/>

<doc:param name="index-category" xmlns="">
<refpurpose>The Texinfo index to use</refpurpose>
<refdescription>
<para>The Texinfo index for <sgmltag class="element">indexterm</sgmltag>
and <sgmltag class="element">index</sgmltag> is specified using the
<sgmltag class="attribute">role</sgmltag> attribute.  If the above
elements do not have a <sgmltag class="attribute">role</sgmltag>, then
the default specified by this parameter is used.
</para>

<para>
The predefined indices are:

<variablelist>
<varlistentry>
<term><literal>c</literal></term>
<term><literal>cp</literal></term>
<listitem><para>Concept index</para></listitem>
</varlistentry>
<varlistentry>
<term><literal>f</literal></term>
<term><literal>fn</literal></term>
<listitem><para>Function index</para></listitem>
</varlistentry>
<varlistentry>
<term><literal>v</literal></term>
<term><literal>vr</literal></term>
<listitem><para>Variable index</para></listitem>
</varlistentry>
<varlistentry>
<term><literal>k</literal></term>
<term><literal>ky</literal></term>
<listitem><para>Keystroke index</para></listitem>
</varlistentry>
<varlistentry>
<term><literal>p</literal></term>
<term><literal>pg</literal></term>
<listitem><para>Program index</para></listitem>
</varlistentry>
<varlistentry>
<term><literal>d</literal></term>
<term><literal>tp</literal></term>
<listitem><para>Data type index</para></listitem>
</varlistentry>
</variablelist>

User-defined indices are not yet supported.
</para>

</refdescription>
</doc:param>


<!-- ==================================================================== -->
<xsl:variable name="qanda-defaultlabel">number</xsl:variable>

<doc:param name="qanda-defaultlabel" xmlns="">
<refpurpose>Sets the default for defaultlabel on QandASet.</refpurpose>
<refdescription>
<para>If no defaultlabel attribute is specified on a QandASet, this
value is used. It must be one of the legal values for the defaultlabel
attribute.
</para>
</refdescription>
</doc:param>

<!-- ==================================================================== -->
<xsl:variable name="qandaset-generate-toc">1</xsl:variable>

<doc:param name="qandaset-generate-toc" xmlns="">
<refpurpose>Is a Table of Contents created for QandASets?</refpurpose>
<refdescription>
<para>If true, a ToC is constructed for QandASets.
</para>
</refdescription>
</doc:param>

</xsl:stylesheet>

