/*
 * DiaSCE is a code editor for C and C++.
 * Copyright (C) 2000  Ander Lozano Prez
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Ander Lozano Prez
 * c/Juan de Gardeazabal 4, 1 D
 * 48004 Bilbao
 * Vizcaya
 * Spain
 *
 * ander1@wanadoo.es
 */

#ifndef MAIN_H
#define MAIN_H

#include <gnome.h>
#include <glade/glade.h>
#include <libxml/tree.h>
#include <libxml/parser.h>
#include <malloc.h>
#include <unistd.h>
#include <pwd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <fcntl.h>
#include <time.h>
#include <string.h>
#include <signal.h>
#include <config.h>
#include "gtksourceview.h"
#include "general.h"
#include "proyecto.h"
#include "archivos.h"
#include "cefv.h"
#include "editor.h"
#include "compilar.h"
#include "preferencias.h"
#include "buscar.h"
#include "autoconf.h"
#include "autodetect.h"
#include "glade.h"
#include "pixmaps.h"
#include "callbacks.h"
#include "externos.h"
#include "cvs.h"

//*******************************************************************

#define VERSION_PROYECTO "1.3"

#define VERSION_PREFERENCIAS "1.3"

#define ULTIMA_FASE_AUTODETECCION LTOTALES+LTOTALES+17

//*******************************************************************

//#define DEBUG
#ifdef DEBUG
	#define DEBUG_MSG(msg) g_print("%s\n",#msg)
#else
	#define DEBUG_MSG(msg)
#endif

//*******************************************************************

#define AUTO_CONF 0x01
#define AUTO_MAKE 0x02
#define AUTO_HEADER 0x04
#define ACLOCAL 0x08
#define CONFIGURE 0X10

//*******************************************************************

enum e_estado_archivos_ventana {PROYECTO_ABRIR,PROYECTO_ANADIR,EXTERNOS_ABRIR};

enum e_estado_proyecto_ventana {NUEVO,PROPIEDADES};

enum {COL_ICONO,COL_NOMBRE,COL_TOTAL};

//*******************************************************************

GladeXML *david_ventana;
GladeXML *acercade_ventana;
GladeXML *archivos_ventana;
GladeXML *proyecto_ventana;
GladeXML *preferencias_ventana;
GladeXML *archivos_arbol_menu;
GladeXML *editor_menu;
GladeXML *buscar_ventana;
GladeXML *nuevo_ventana;
GladeXML *autodetect_ventana;
GladeXML *log_ventana;
GladeXML *druida_glade_ventana;
GladeXML *add_files_ventana;
GladeXML *cvs_password_ventana;

GtkSourceBuffer *empty_buffer;

enum e_estado_archivos_ventana estado_archivos_ventana;

enum e_estado_proyecto_ventana estado_proyecto_ventana;

guchar autoconfiguracion;

gchar *commandline_project;

gboolean mensajes_button_pressed;

gboolean david_ventana_maximizada;

//*******************************************************************

gboolean david_init(gpointer datos);

extern gchar *strcasestr(gchar *,gchar *);

#endif
