/*!

\if MANPAGES
\page dcmpssnd Network send for presentation state viewer
\else
\page dcmpssnd dcmpssnd: Network send for presentation state viewer
\endif

\section synopsis SYNOPSIS

\verbatim
dcmpssnd [options] config-file target study [series] [instance]
\endverbatim

\section description DESCRIPTION

The \b dcmpssnd application is invoked by the Grayscale Softcopy Presentation
State Viewer and is not intended to be invoked manually.  The application
reads the common configuration file which is shared between the different
components of the viewer, attempts to establish a DICOM association with
the selected target and, if successful, selects the required DICOM
instances from the viewer's database and transmits them using the DICOM
storage service class, which is supported as SCU.  When transmission is
finished (successfully or unsuccessfully), the application terminates. This
application supports the same storage SOP classes as the \b storescu utility,
but does not support encapsulated transfer syntaxes.  See the full
conformance statement for further details.


\section parameters PARAMETERS

\verbatim
config-file  configuration file to be read

target       symbolic identifier of send target in config file

study        study instance UID of study in database to be sent

series       series instance UID (default: send complete study)

instance     SOP instance UID (default: send complete series)
\endverbatim

\section options OPTIONS

\subsection general_options general options
\verbatim
  -h  --help
        print this help text and exit

      --version
        print version information and exit

  -v  --verbose
        verbose mode, print processing details

  -d  --debug
        debug mode, print debug information
\endverbatim

\section command_line COMMAND LINE

All command line tools use the following notation for parameters: square
brackets enclose optional values (0-1), three trailing dots indicate that
multiple values are allowed (1-n), a combination of both means 0 to n values.

Command line options are distinguished from parameters by a leading '+' or '-'
sign, respectively.  Usually, order and position of command line options are
arbitrary (i.e. they can appear anywhere).  However, if options are mutually
exclusive the rightmost appearance is used.  This behaviour conforms to the
standard evaluation rules of common Unix shells.

In addition, one or more command files can be specified using an '@' sign as a
prefix to the filename (e.g. <em>\@command.txt</em>).  Such a command argument
is replaced by the content of the corresponding text file (multiple
whitespaces are treated as a single separator) prior to any further
evaluation.  Please note that a command file cannot contain another command
file.  This simple but effective approach allows to summarize common
combinations of options/parameters and avoids longish and confusing command
lines (an example is provided in file <em>share/data/dumppat.txt</em>).

\section environment ENVIRONMENT

The \b dcmpssnd utility will attempt to load DICOM data dictionaries specified
in the \e DCMDICTPATH environment variable.  By default, i.e. if the
\e DCMDICTPATH environment variable is not set, the file
<em>\<PREFIX\>/lib/dicom.dic</em> will be loaded unless the dictionary is built
into the application (default for Windows).

The default behaviour should be preferred and the \e DCMDICTPATH environment
variable only used when alternative data dictionaries are required.  The
\e DCMDICTPATH environment variable has the same format as the Unix shell
\e PATH variable in that a colon (":") separates entries.  The data dictionary
code will attempt to load each file specified in the \e DCMDICTPATH
environment variable.  It is an error if no data dictionary can be loaded.

\section files FILES

<em>etc/dcmpstat.cfg</em> - sample configuration file

\section see_also SEE ALSO

<b>dcmpsrcv</b>(1), <b>storescu</b>(1)

\section copyright COPYRIGHT

Copyright (C) 1998-2004 by Kuratorium OFFIS e.V., Escherweg 2, 26121 Oldenburg,
Germany.

*/