<?php
	/**************************************************************************\
	* Double Choco Latte                                                       *
	* http://dcl.sourceforge.net/                                              *
	* This application written by Michael Dean <mdean@users.sourceforge.net>   *
	* --------------------------------------------                             *
	*  This program is free software; you can redistribute it and/or modify it *
	*  under the terms of the GNU General Public License as published by the   *
	*  Free Software Foundation; either version 2 of the License, or (at your  *
	*  option) any later version.                                              *
	\**************************************************************************/

	/* $Id: index.php,v 1.2.2.1.2.6 2004/01/01 18:20:00 mdean Exp $ */

include('inc/config.php');
if (@is_dir('../phpgwapi') && @file_exists('../header.inc.php'))
{
	// In phpGroupWare, so redirect to kick start the session
	global $cd;
	
	if (!IsSet($cd) || $cd == 2)
		header('Location: ' . DCL_WWW_ROOT . "main.php?menuAction=htmlMyDCL.show\n");
		
	exit;
}
else if (@is_dir('../../modules') && @file_exists('../../xoops.css'))
{
	// And this one is for starting a session in XOOPS
	global $cd;
	
	if (!IsSet($cd) || $cd == 2)
		header('Location: ' . DCL_WWW_ROOT . "main.php?menuAction=htmlMyDCL.show\n");
		
	exit;
}
else
{
	if (!isset($dcl_info))
	{
		// If we had a session, some of the config would be in it
		// and would have been removed above.
		include('inc/class.dbConfig.inc.php');
		$oConfig = new dbConfig;
		$dcl_info = array();
		$oConfig->Load();
	}

	include('inc/class.DCLTemplate.inc.php');
	function GetDomainCombo()
	{
		global $dcl_domain_info;

		if (count($dcl_domain_info) > 1)
		{
			$retVal = '<select name="DOMAIN">';
			reset($dcl_domain_info);
			while (list($key, $val) = each($dcl_domain_info))
				$retVal .= '<option value="' . $key . '">' . $val['name'] . '</option>';

			$retVal .= '</select>';
		}
		else
			$retVal = '<input type="hidden" name="DOMAIN" value="default">' . $dcl_domain_info['default']['name'];

		return $retVal;
	}

	$t = new DCLTemplate;
	$t->set_root('templates/' . $dcl_info['DCL_DEF_TEMPLATE_SET']);
	$t->set_file(array('hForm' => 'login.tpl'));
	$t->set_block('hForm', 'error', 'hError');
	$t->set_var('hError', '');
	if (IsSet($GLOBALS['cd']))
	{
		switch ($GLOBALS['cd'])
		{
			case 1:
				$t->set_var('VAL_ERROR', 'Invalid login or password');
				break;
			case 2:
				$t->set_var('VAL_ERROR', 'Could not verify session');
				break;
			case 3:
				$t->set_var('VAL_ERROR', 'Could not connect to database');
				break;
			case 4:
				$t->set_var('VAL_ERROR', 'Logout successful');
				break;
			default:
				$t->set_var('VAL_ERROR', 'Unknown error');
		}

		$t->parse('hError', 'error');
	}

	$t->set_var('COLOR_DARK', $dcl_info['DCL_COLOR_DARK']);
	$t->set_var('COLOR_LIGHT', $dcl_info['DCL_COLOR_LIGHT']);
	$t->set_var('TXT_TITLE', 'Double Choco Latte Login');
	$t->set_var('TXT_LOGIN', 'Login and Have a Double!');
	$t->set_var('TXT_USER', 'User');
	$t->set_var('TXT_PASSWORD', 'Password');
	$t->set_var('TXT_DOMAIN', 'Domain');
	$t->set_var('BTN_LOGIN', 'Login');
	$t->set_var('BTN_CLEAR', 'Clear');
	$t->set_var('CMB_DOMAIN', GetDomainCombo());

	if (IsSet($GLOBALS['refer_to']))
		$t->set_var('HIDDEN_VARS', sprintf('<input type="hidden" name="refer_to" value="%s">', urldecode($GLOBALS['refer_to'])));
	else
		$t->set_var('HIDDEN_VARS', '');

	$t->pparse('out', 'hForm');
}
?>
