<?php
/*
 * $Id: class.dbTimeCards.inc.php,v 1.3.4.2 2003/05/30 03:56:39 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

class dbTimeCards extends dclDB
{
	var $id;
	var $jcn;
	var $seq;
	var $actionon;
	var $inputon;
	var $actionby;
	var $status;
	var $action;
	var $hours;
	var $summary;
	var $description;
	var $revision;
	var $reassign_from_id;
	var $reassign_to_id;

	function dbTimeCards()
	{
		// Table Fields
		$this->fieldArray = array('id', 'jcn', 'seq', 'actionon', 'inputon', 'actionby', 
				'status', 'action', 'hours', 'summary', 'description', 'revision', 'reassign_from_id', 'reassign_to_id');

		// Foreign Keys
		$this->foreignKeys = array();

		$this->cacheEnabled = false;
		$this->dclDB();
	}

	function Add()
	{
		global $dcl_info;

		if ($this->conn == 0)
		{
			if(!$this->Connect())
				return -1;
		}

		$objWO = CreateObject('dcl.dbWorkorders');
		if ($objWO->Load($this->jcn, $this->seq) == -1)
		{
			printf(STR_DB_WORKORDERLOADERR, $this->jcn, $this->seq);
			return;
		}

		$currstatus = $objWO->status;
		$justStarted = $objWO->IsFieldNull('starton');
		$idSQL = $this->GetNewIDSQLForTable('timecards');

		$query  = 'INSERT INTO timecards (';
		if ($idSQL != '')
			$query .= 'id,';
		$query .= 'jcn, seq, actionon, inputon, actionby, status, action, hours, summary, description, revision, reassign_from_id, reassign_to_id';
		$query .= ') VALUES (';
		if ($idSQL != '')
			$query .= $idSQL . ',';
		$query .= $this->jcn . ',' . $this->seq . ',';
		$query .= $this->DisplayToSQL($this->actionon) . ',';
		$query .= $this->GetDateSQL() . ',' . $this->actionby . ',';
		$query .= $this->status . ',' . $this->action . ',' . $this->hours . ',\'';
		$query .= $this->DBAddSlashes($this->summary) . '\'';
		$query .= ',\'' . $this->DBAddSlashes($this->description) . '\'';
		$query .= ',\'' . $this->DBAddSlashes($this->revision) . '\'';
		
		// Reassign if selected and able
		if ($this->reassign_to_id > 0 && $GLOBALS['g_oSec']->HasSecLvl($dcl_info['DCL_ASSIGN_WO']) && $objWO->responsible != $this->reassign_to_id)
		{
			$query .= ',' . $objWO->responsible;
			$query .= ',' . $this->reassign_to_id;
			$objWO->responsible = $this->reassign_to_id;
		}
		else
			$query .= ', NULL, NULL';

		$query .= ')';

		$objWO->lastactionon = date($dcl_info['DCL_TIMESTAMP_FORMAT']);
		$objWO->totalhours = $objWO->totalhours + $this->hours;
		$objWO->etchours = $GLOBALS['etchours'];
		if ($currstatus != $this->status)
		{
			$objWO->status = $this->status;
			$objWO->statuson = date($dcl_info['DCL_TIMESTAMP_FORMAT']);
			$oStatus = CreateObject('dcl.dbStatuses');
			if ($oStatus->GetStatusType($this->status) == 2 && $oStatus->GetStatusType($currstatus) != 2)
			{
				$objWO->closedby = $this->actionby;
				$objWO->closedon = $this->actionon;
			}
			else if ($oStatus->GetStatusType($currstatus) == 2)
				{
					$objWO->closedby = 0;
					$objWO->closedon = '';
				}
		}
		// ensure the etc hours do not get anything but zero when closed
		$oStatus = CreateObject('dcl.dbStatuses');
		if ($oStatus->GetStatusType($objWO->status) == 2)
			$objWO->etchours = 0.0;
		if ($justStarted == 1)
			$objWO->starton = $this->actionon;

		$this->BeginTransaction();
		$this->Insert($query);
		$objWO->Edit();
		$this->EndTransaction();
	}

	function Edit()
	{
		// Does not update reassign information - that's historical!
		$query = 'UPDATE timecards SET actionon=' . $this->DisplayToSQL($this->actionon);
		$query .= ',actionby=' . $this->actionby . ',status=' . $this->status . ',action=';
		$query .= $this->action . ',hours=' . $this->hours . ',summary=\'' . $this->DBAddSlashes($this->summary);
		$query .= '\',description=\'' . $this->DBAddSlashes($this->description) . '\',revision=\'' . $this->DBAddSlashes($this->revision) . '\' ';
		$query .= ' WHERE id=' . $this->id;

		$this->Execute($query);
	}

	function Delete()
	{
		$query = sprintf('DELETE FROM timecards WHERE id=%d', $this->id);
		$this->Execute($query);
	}

	function GetRow()
	{
		if (!$this->res)
			return -1;

		if (count($this->Record) < 1)
			return -1;

		$this->id = $this->f('id');
		$this->jcn = $this->f('jcn');
		$this->seq = $this->f('seq');
		$this->actionon = $this->FormatDateForDisplay($this->f('actionon'));
		$this->inputon = $this->FormatTimeStampForDisplay($this->f('inputon'));
		$this->actionby = $this->f('actionby');
		$this->status = $this->f('status');
		$this->action = $this->f('action');
		$this->hours = $this->f('hours');
		$this->summary = $this->f('summary');
		$this->description = $this->f('description');
		$this->revision = $this->f('revision');
		$this->reassign_from_id = $this->f('reassign_from_id');
		$this->reassign_to_id = $this->f('reassign_to_id');

		return 0;
	}

	function Load($id)
	{
		$this->Clear();

		if ($this->conn == 0)
		{
			if (!$this->Connect())
				return -1;
		}

		$sql = 'SELECT id, jcn, seq, ';
		$sql .= $this->ConvertDate('actionon', 'actionon');
		$sql .= ', ' . $this->ConvertTimestamp('inputon', 'inputon');
		$sql .= ', actionby, status, action, hours, summary, description, revision, reassign_from_id, reassign_to_id';
		$sql .= " FROM timecards WHERE id=$id";
		if (!$this->Query($sql))
			return -1;

		$this->next_record();
		return $this->GetRow();
	}

	function Clear()
	{
		$this->id = 0;
		$this->jcn = 0;
		$this->seq = 0;
		$this->actionon = '';
		$this->inputon = '';
		$this->actionby = 0;
		$this->status = 0;
		$this->action = 0;
		$this->hours = 0.0;
		$this->summary = '';
		$this->description = '';
		$this->revision = '';
		$this->reassign_from_id = 0;
		$this->reassign_to_id = 0;
	}

	function GetTimeCards($jcn, $seq)
	{
		global $dcl_info;

		$this->Clear();

		if ($this->conn == 0)
		{
			if (!$this->Connect())
				return -1;
		}

		$sql = 'SELECT id, jcn, seq, ';
		$sql .= $this->ConvertDate('actionon', 'actionon');
		$sql .= ', ' . $this->ConvertTimestamp('inputon', 'inputon');
		$sql .= ', actionby, status, action, hours, summary, description, revision, reassign_from_id, reassign_to_id';
		$sql .= " FROM timecards WHERE jcn=$jcn and seq=$seq ORDER BY id " . $dcl_info['DCL_TIME_CARD_ORDER'];
		if (!$this->Query($sql))
			return -1;

		return 1;
	}
}
?>
