/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.utils;

import java.io.Writer;
import java.util.Stack;
import org.apache.xalan.res.XSLMessages;
import org.apache.xml.utils.XMLCharacterRecognizer;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class DOMBuilder
implements ContentHandler,
LexicalHandler {
    public Document m_doc;
    protected Node m_currentNode = null;
    public DocumentFragment m_docFrag = null;
    protected Stack m_elemStack = new Stack();
    protected boolean m_inCData = false;

    public DOMBuilder(Document document) {
        this.m_doc = document;
    }

    public DOMBuilder(Document document, DocumentFragment documentFragment) {
        this.m_doc = document;
        this.m_docFrag = documentFragment;
    }

    public DOMBuilder(Document document, Node node) {
        this.m_doc = document;
        this.m_currentNode = node;
    }

    protected void append(Node node) throws SAXException {
        Node node2 = this.m_currentNode;
        if (node2 != null) {
            node2.appendChild(node);
        } else if (this.m_docFrag != null) {
            this.m_docFrag.appendChild(node);
        } else {
            boolean bl = true;
            short s = node.getNodeType();
            if (s == 3) {
                String string = node.getNodeValue();
                if (string != null && string.trim().length() > 0) {
                    throw new SAXException(XSLMessages.createXPATHMessage(63, null));
                }
                bl = false;
            } else if (s == 1 && this.m_doc.getDocumentElement() != null) {
                throw new SAXException(XSLMessages.createXPATHMessage(64, null));
            }
            if (bl) {
                this.m_doc.appendChild(node);
            }
        }
    }

    public void cdata(char[] cArray, int n, int n2) throws SAXException {
        if (this.isOutsideDocElem() && XMLCharacterRecognizer.isWhiteSpace(cArray, n, n2)) {
            return;
        }
        String string = new String(cArray, n, n2);
        this.append(this.m_doc.createCDATASection(string));
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.isOutsideDocElem() && XMLCharacterRecognizer.isWhiteSpace(cArray, n, n2)) {
            return;
        }
        if (this.m_inCData) {
            this.cdata(cArray, n, n2);
            return;
        }
        String string = new String(cArray, n, n2);
        Text text = this.m_doc.createTextNode(string);
        this.append(text);
    }

    public void charactersRaw(char[] cArray, int n, int n2) throws SAXException {
        if (this.isOutsideDocElem() && XMLCharacterRecognizer.isWhiteSpace(cArray, n, n2)) {
            return;
        }
        String string = new String(cArray, n, n2);
        this.append(this.m_doc.createProcessingInstruction("xslt-next-is-raw", "formatter-to-dom"));
        this.append(this.m_doc.createTextNode(string));
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        this.append(this.m_doc.createComment(new String(cArray, n, n2)));
    }

    public void endCDATA() throws SAXException {
        this.m_inCData = false;
    }

    public void endDTD() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        this.m_elemStack.pop();
        this.m_currentNode = this.m_elemStack.isEmpty() ? null : (Node)this.m_elemStack.peek();
    }

    public void endEntity(String string) throws SAXException {
    }

    public void endPrefixMapping(String string) throws SAXException {
    }

    public void entityReference(String string) throws SAXException {
        this.append(this.m_doc.createEntityReference(string));
    }

    public Node getCurrentNode() {
        return this.m_currentNode;
    }

    public Node getRootNode() {
        return this.m_docFrag != null ? this.m_docFrag : this.m_doc;
    }

    public Writer getWriter() {
        return null;
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        if (this.isOutsideDocElem()) {
            return;
        }
        String string = new String(cArray, n, n2);
        this.append(this.m_doc.createTextNode(string));
    }

    private boolean isOutsideDocElem() {
        return this.m_docFrag == null && this.m_elemStack.size() == 0 && (this.m_currentNode == null || this.m_currentNode.getNodeType() == 9);
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        this.append(this.m_doc.createProcessingInstruction(string, string2));
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void setIDAttribute(String string, Element element) {
    }

    public void skippedEntity(String string) throws SAXException {
    }

    public void startCDATA() throws SAXException {
        this.m_inCData = true;
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
    }

    public void startDocument() throws SAXException {
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        Element element = string == null || string.length() == 0 ? this.m_doc.createElement(string3) : this.m_doc.createElementNS(string, string3);
        this.append(element);
        try {
            int n = attributes.getLength();
            if (n != 0) {
                int n2 = 0;
                while (n2 < n) {
                    String string4;
                    if (attributes.getType(n2).equalsIgnoreCase("ID")) {
                        this.setIDAttribute(attributes.getValue(n2), element);
                    }
                    if ((string4 = attributes.getURI(n2)) == null) {
                        string4 = "";
                    }
                    String string5 = attributes.getQName(n2);
                    if (string4.length() == 0) {
                        element.setAttribute(string5, attributes.getValue(n2));
                    } else {
                        element.setAttributeNS(string4, string5, attributes.getValue(n2));
                    }
                    ++n2;
                }
            }
            this.m_elemStack.push(element);
            this.m_currentNode = element;
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    public void startEntity(String string) throws SAXException {
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
    }
}

