/* 
 * new_pud.c
 *
 * crafted - a pud editor for the freecraft project.
 * 
 * Copyright (C) 2001-2002 DindinX <David@dindinx.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>

#include "crafted.h"
#include "craftedintl.h"

static GtkWidget *new_pud_dialog = NULL;

/*************************************************************************
*  new_pud_ok
**************************************************************************/
static void new_pud_ok(void)
{
  gint width, height;
  gint terrain;
  gint i;
  GtkWidget *entry;
  GtkWidget *spin;

  terrain = GPOINTER_TO_INT(gtk_object_get_data(GTK_OBJECT(new_pud_dialog), "terrain"));

  spin = gtk_object_get_data(GTK_OBJECT(new_pud_dialog), "width");
  width = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin));
  spin = gtk_object_get_data(GTK_OBJECT(new_pud_dialog), "height");
  height = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin));

  if (Pud.path) g_free(Pud.path);
  Pud.path        = g_strdup("untitled");
  Pud.is_loaded   = TRUE;
  Pud.readonly    = FALSE;
  Pud.modified    = FALSE;
  Pud.version     = 1;
  Pud.sub_version = 1;
  /* get description */
  entry = gtk_object_get_data(GTK_OBJECT(new_pud_dialog), "description");
  if (Pud.description) g_free(Pud.description);
  Pud.description = g_strdup(gtk_entry_get_text(GTK_ENTRY(entry)));
  Pud.terrain     = terrain;
  Pud.width       = width;
  Pud.height      = height;
  for (i=0 ; i<15 ; i++)
  {
    Pud.player[i].owner = 3; /* nobody */
    Pud.player[i].side = 0; /* human */
    Pud.player[i].gold = 5000;
    Pud.player[i].wood = 2000;
    Pud.player[i].oil = 2000;
  }
  Pud.player[15].owner = 2; /* neutral */
  Pud.player[15].side = 2; /* neutral */
  Pud.player[15].gold = 1000;
  Pud.player[15].wood = 1000;
  Pud.player[15].oil = 1000;

  if (Pud.fields) g_free(Pud.fields);
  Pud.fields = g_new(guint16, Pud.width * Pud.height);
  Pud.units = NULL; /* FIXME: free */
  for (i = 0 ; i < Pud.width * Pud.height ; i++)
    Pud.fields[i] = 0x0050;
  after_load();
  gtk_widget_destroy(new_pud_dialog);
}

/*************************************************************************
*  new_pud_terrain_changed
**************************************************************************/
static void new_pud_terrain_changed(GtkWidget *dum, gpointer data)
{
  gtk_object_set_data(GTK_OBJECT(new_pud_dialog), "terrain", data);
}

/*************************************************************************
*  new_pud_callback
**************************************************************************/
void new_pud_callback(void)
{
  GtkWidget *label, *button, *hbox;
  GtkWidget *menu_item, *option_menu, *menu;
  GtkWidget *entry, *table, *frame, *spin;
  GtkAdjustment *adj;
  gint i;

  if (new_pud_dialog)
  {
    if (!GTK_WIDGET_VISIBLE(new_pud_dialog))
    {
      gtk_widget_show(new_pud_dialog);
    } else
    {
      gdk_window_raise(new_pud_dialog->window);
    }
    return;
  }

  new_pud_dialog = gtk_dialog_new();
  gtk_signal_connect(GTK_OBJECT(new_pud_dialog), "destroy",
                     (GtkSignalFunc)gtk_widget_destroyed,
                     &new_pud_dialog);

  /* terrain */
  hbox = gtk_hbox_new(FALSE, 10);
  gtk_container_set_border_width(GTK_CONTAINER(hbox), 5);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(new_pud_dialog)->vbox), hbox, FALSE, FALSE, 0);
  label = gtk_label_new(_("Type of terrain:"));
  gtk_box_pack_start_defaults(GTK_BOX(hbox), label);
  menu = gtk_menu_new();
  menu_item = gtk_menu_item_new_with_label(_("Summer"));
  gtk_menu_append(GTK_MENU(menu), menu_item);
  gtk_widget_show(menu_item);
  gtk_signal_connect(GTK_OBJECT(menu_item), "activate",
                     (GtkSignalFunc)new_pud_terrain_changed,
                     GINT_TO_POINTER(0));
  menu_item = gtk_menu_item_new_with_label(_("Winter"));
  gtk_menu_append(GTK_MENU(menu), menu_item);
  gtk_widget_show(menu_item);
  gtk_signal_connect(GTK_OBJECT(menu_item), "activate",
                     (GtkSignalFunc)new_pud_terrain_changed,
                     GINT_TO_POINTER(1));
  menu_item = gtk_menu_item_new_with_label(_("Wasteland"));
  gtk_menu_append(GTK_MENU(menu), menu_item);
  gtk_widget_show(menu_item);
  gtk_signal_connect(GTK_OBJECT(menu_item), "activate",
                     (GtkSignalFunc)new_pud_terrain_changed,
                     GINT_TO_POINTER(2));
  menu_item = gtk_menu_item_new_with_label(_("Swamp"));
  gtk_menu_append(GTK_MENU(menu), menu_item);
  gtk_widget_show(menu_item);
  gtk_signal_connect(GTK_OBJECT(menu_item), "activate", 
                     (GtkSignalFunc)new_pud_terrain_changed,
                     GINT_TO_POINTER(3));
  option_menu = gtk_option_menu_new();
  gtk_option_menu_set_menu(GTK_OPTION_MENU(option_menu), menu);
  gtk_box_pack_start_defaults(GTK_BOX(hbox), option_menu);
  gtk_option_menu_set_history(GTK_OPTION_MENU(option_menu), 0);
  gtk_object_set_data(GTK_OBJECT(new_pud_dialog), "terrain", GINT_TO_POINTER(0));

  /* size */
  frame = gtk_frame_new(_(" Pud size "));
  gtk_box_pack_start_defaults(GTK_BOX(GTK_DIALOG(new_pud_dialog)->vbox), frame);
  table = gtk_table_new(2,2, FALSE);
  gtk_container_add(GTK_CONTAINER(frame), table);
  label = gtk_label_new(_("Width:"));
  gtk_table_attach_defaults(GTK_TABLE(table), label, 0,1, 0,1);
  adj = (GtkAdjustment *)gtk_adjustment_new(128, 32, 1024, 32, 32, 32);
  spin = gtk_spin_button_new(adj, 0.5, 0);
  gtk_table_attach_defaults(GTK_TABLE(table), spin, 1,2, 0,1);
  gtk_object_set_data(GTK_OBJECT(new_pud_dialog), "width", spin);
  label = gtk_label_new(_("Height:"));
  gtk_table_attach_defaults(GTK_TABLE(table), label, 0,1, 1,2);
  adj = (GtkAdjustment *)gtk_adjustment_new(128, 32, 1024, 32, 32, 32);
  spin = gtk_spin_button_new(adj, 0.5, 0);
  gtk_table_attach_defaults(GTK_TABLE(table), spin, 1,2, 1,2);
  gtk_object_set_data(GTK_OBJECT(new_pud_dialog), "height", spin);

  /* Descriptions */
  label = gtk_label_new(_("Description:"));
  gtk_box_pack_start_defaults(GTK_BOX(GTK_DIALOG(new_pud_dialog)->vbox), label);
  
  entry = gtk_entry_new();
  gtk_box_pack_start_defaults(GTK_BOX(GTK_DIALOG(new_pud_dialog)->vbox), entry);
  gtk_entry_set_text(GTK_ENTRY(entry), "new pud");
  gtk_object_set_data(GTK_OBJECT(new_pud_dialog), "description", entry);

  /* Buttons */
  button = gtk_button_new_with_label(_(" OK "));
  gtk_box_pack_start_defaults(GTK_BOX(GTK_DIALOG(new_pud_dialog)->action_area), button);
  gtk_signal_connect_object(GTK_OBJECT(button), "clicked",
                            (GtkSignalFunc)new_pud_ok,
                            GTK_OBJECT(new_pud_dialog));

  button = gtk_button_new_with_label(_(" Cancel "));
  gtk_box_pack_start_defaults(GTK_BOX(GTK_DIALOG(new_pud_dialog)->action_area), button);
  gtk_signal_connect_object(GTK_OBJECT(button), "clicked",
                            (GtkSignalFunc)gtk_widget_destroy,
                            GTK_OBJECT(new_pud_dialog));

  gtk_window_set_modal(GTK_WINDOW(new_pud_dialog), TRUE);
  
  gtk_widget_show_all(new_pud_dialog);
}

