/*

compilercacheunifier

- has to be run AFTER preprocessor run !
- may only be used if all source level debugging options are turned off.

this source is GPL

shamelessly stolen from http://www.lysator.liu.se/c/ANSI-C-grammar-l.html
modified by erikyyy

*/

%option nounput

D                       [0-9]
L                       [a-zA-Z_]
H                       [a-fA-F0-9]
E                       [Ee][+-]?{D}+
FS                      (f|F|l|L)
IS                      (u|U|l|L)*

%{

inline void p();
void f();

%}

%%

^\ *#\ *[0-9]+.*$	{ /* ignore line directives, this kills source level debugging! */ }
#.*$			{ p(); /* pass # stuff like pragma */ }

{L}({L}|{D})*           { p(); }

0[xX]{H}+{IS}?          { p(); }
0{D}+{IS}?              { p(); }
{D}+{IS}?               { p(); }
L?'(\\.|[^\\'])+'       { p(); }

{D}+{E}{FS}?            { p(); }
{D}*"."{D}+({E})?{FS}?  { p(); }
{D}+"."{D}*({E})?{FS}?  { p(); }

L?\"(\\.|[^\\"])*\"     { p(); }

"..."                   { p(); }
">>="                   { p(); }
"<<="                   { p(); }
"+="                    { p(); }
"-="                    { p(); }
"*="                    { p(); }
"/="                    { p(); }
"%="                    { p(); }
"&="                    { p(); }
"^="                    { p(); }
"|="                    { p(); }
">>"                    { p(); }
"<<"                    { p(); }
"++"                    { p(); }
"--"                    { p(); }
"->"                    { p(); }
"&&"                    { p(); }
"||"                    { p(); }
"<="                    { p(); }
">="                    { p(); }
"=="                    { p(); }
"!="                    { p(); }
";"                     { p(); }
("{"|"<%")              { p(); }
("}"|"%>")              { p(); }
","                     { p(); }
":"                     { p(); }
"="                     { p(); }
"("                     { p(); }
")"                     { p(); }
("["|"<:")              { p(); }
("]"|":>")              { p(); }
"."                     { p(); }
"&"                     { p(); }
"!"                     { p(); }
"~"                     { p(); }
"-"                     { p(); }
"+"                     { p(); }
"*"                     { p(); }
"/"                     { p(); }
"%"                     { p(); }
"<"                     { p(); }
">"                     { p(); }
"^"                     { p(); }
"|"                     { p(); }
"?"                     { p(); }

[ \t\v\n\f]             { }
.                       { f(); }

%%

/* print */
inline void p()
{
  printf("%s\n", yytext);
};

/* fail */
void f()
{
  exit(1);
};

/* main */
int main()
{
  yylex ();
  fflush(stdout);
  if (feof(stdout) || ferror(stdout)) exit(1);
  return 0;
};
