#ifndef COIN_SOPACKEDCOLORV20_H
#define COIN_SOPACKEDCOLORV20_H

/**************************************************************************\
 *
 *  This file is part of the Coin 3D visualization library.
 *  Copyright (C) 1998-2003 by Systems in Motion. All rights reserved.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public License
 *  version 2.1 as published by the Free Software Foundation. See the
 *  file LICENSE.LGPL at the root directory of the distribution for
 *  more details.
 *
 *  If you want to use Coin for applications not compatible with the
 *  LGPL, please contact SIM to acquire a Professional Edition license.
 *
 *  Systems in Motion, Teknobyen, Abels Gate 5, 7030 Trondheim, NORWAY
 *  http://www.sim.no support@sim.no Voice: +47 22114160 Fax: +47 22207097
 *
\**************************************************************************/

#include <Inventor/fields/SoMFUInt32.h>
#include <Inventor/nodes/SoSubNode.h>

class SoPackedColor;

class COIN_DLL_API SoPackedColorV20 : public SoNode {
  typedef SoNode inherited;

  SO_NODE_HEADER(SoPackedColorV20);

public:
  static void initClass(void);
  SoPackedColorV20(void);

  SoMFUInt32 rgba;

  SoPackedColor * createUpgrade(void) const;

protected:
  virtual ~SoPackedColorV20();
};

#endif // !COIN_SOPACKEDCOLORV20_H
