/*
 * Author:	Peter Holst Andersen
 * Last change:	August, 1994
 * Contents:	Functions to perform vector operations.
 */

#include <stdio.h>
#include <math.h>
#include "ray.h"


myfloat vector_dot(vectorType *A, vectorType *B)
{
  return (A->x * B->x + A->y * B->y + A->z * B->z);
}

/*vector_norm(A) = |A|, A = A/|A|*/

myfloat vector_norm(vectorType *A)
{
  myfloat a, b;
  
  if ((a = vector_dot(A, A)) <= 0.0) return 0.0;
  b = sqrt((double) a);
  A->x /= b;
  A->y /= b;
  A->z /= b;
  return b;
}

/* \begin{C-Mix hack} */

myfloat vector_norm_S(vectorType *A) { vector_norm(A); }

/* \end{C-Mix hack} */

void vector_sub(vectorType *A, vectorType *B, vectorType *C)
{
  C->x = A->x - B->x;
  C->y = A->y - B->y;
  C->z = A->z - B->z;
}

void vector_sub_S(vectorType *A, vectorType *B, vectorType *C) {
  vector_sub(A, B, C);
}

void vector_cross(vectorType *A, vectorType *B, vectorType *C)
{
  C->x = (A->y * B->z) - (A->z * B->y);
  C->y = (A->z * B->x) - (A->x * B->z);
  C->z = (A->x * B->y) - (A->y * B->x);
}

myfloat vector_norm_cross(vectorType *A, vectorType *B, vectorType *C)
{
  vector_cross(A, B, C);
  return vector_norm(C);
}

void vector_scale(myfloat s, vectorType *A, vectorType *B)
{
  B->x = A->x * s;
  B->y = A->y * s;
  B->z = A->z * s;
}
